/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.wizard;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.client.view.wizard.ExportConfirmPage;
import com.interpress_project.modernshare.client.view.wizard.ExportWelcomePage;
import com.interpress_project.modernshare.client.view.wizard.ExportWizardPage1;
import com.interpress_project.modernshare.client.view.wizard.ExportWizardPage2;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class LocalExportWizard
extends Wizard {
    private final ViewManager vmgr = ViewManager.getInstance();
    private final LogEventSource logEventSource = LogEventSource.getInstance();
    private ExportWelcomePage exportWelcomePage = new ExportWelcomePage();
    private ExportWizardPage1 exportWizardPage1 = null;
    private ExportWizardPage2 exportWizardPage2 = new ExportWizardPage2();
    private ExportConfirmPage exportConfirmPage = new ExportConfirmPage();

    public LocalExportWizard(ArrayList<ISVNFileItem> revlist) {
        this.addPage((IWizardPage)this.exportWelcomePage);
        this.exportWizardPage1 = new ExportWizardPage1(revlist);
        this.addPage((IWizardPage)this.exportWizardPage1);
        this.addPage((IWizardPage)this.exportWizardPage2);
        this.addPage((IWizardPage)this.exportConfirmPage);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0 - \u53d6\u308a\u51fa\u3057\u30a6\u30a3\u30b6\u30fc\u30c9");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                LocalExportWizard.this.export(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException ex) {
            this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getLocalizedMessage(), LogEventType.ERROR, ex));
            this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException interruptedException) {
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(IProgressMonitor monitor) throws InvocationTargetException {
        ISVNFileItem item = this.exportWizardPage1.getISVNFileItem();
        String path = this.exportWizardPage2.getLocalFileName();
        try {
            monitor.beginTask("\u30c7\u30fc\u30bf\u306e\u53d6\u308a\u51fa\u3057\u3092\u958b\u59cb\u3057\u307e\u3059...", 1);
            SVNCommandFactory factory = SVNCommandFactory.getInstance();
            ISVNCommand command = factory.createLocalExportCommand(item, path);
            SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
            cmdmgr.execCommand(command);
            monitor.worked(1);
        }
        catch (CommandException ex) {
            ex.printStackTrace();
        }
        finally {
            monitor.done();
        }
    }
}

