/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.wizard;

import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.view.wizard.ExportWizardPage2;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExportWizardPage1
extends WizardPage {
    private final ArrayList<ISVNFileItem> revlist;
    private Table tblRevision = null;
    private ISVNFileItem fileItem = null;

    public ExportWizardPage1(ArrayList<ISVNFileItem> revlist) {
        super("ExportWizardPage1");
        this.setTitle("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30e6\u30fc\u30b6\u30d5\u30a9\u30eb\u30c0\u6307\u5b9a");
        this.setDescription("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u53ef\u80fd\u306a\u30e6\u30fc\u30b6\u30d5\u30a9\u30eb\u30c0(\u30bf\u30b0)\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002\u4ee5\u4e0b\u306e\u30ea\u30b9\u30c8\u304b\u3089\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u3092\u3057\u305f\u3044\u30bf\u30b0\u540d\u3092\u9078\u629e\u3057\u307e\u3059\u3002");
        this.PageComplete();
        this.revlist = revlist;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        this.createTable(composite);
        for (int i = 0; i < this.revlist.size(); ++i) {
            ISVNFileItem item = this.revlist.get(i);
            TableItem tableItem = new TableItem(this.tblRevision, 0);
            String name = item.getName();
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            tableItem.setText(new String[]{name, String.valueOf(item.getRevision()), String.valueOf(item.getLastChangedRevision()), item.getLastCommitAuthor(), item.getLastChangedDate().toString(), item.getURL(), item.getUUID()});
            tableItem.setData((Object)item);
        }
        this.tblRevision.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent event) {
                Table table = (Table)event.getSource();
                TableItem[] items = table.getSelection();
                ExportWizardPage1.this.fileItem = (ISVNFileItem)items[0].getData();
                ExportWizardPage1.this.PageComplete();
            }
        });
        this.setControl((Control)composite);
    }

    private void createTable(Composite composite) {
        Font font = new Font((Device)composite.getDisplay(), "MS UI Gothic", 9, 0);
        Label label = new Label(composite, 0);
        label.setText("\u30bf\u30b0\u30ea\u30b9\u30c8\u4e00\u89a7:");
        this.tblRevision = new Table(composite, 0x10010300);
        GridData gd = new GridData(1808);
        this.tblRevision.setLayoutData((Object)gd);
        this.tblRevision.setFont(font);
        this.tblRevision.setHeaderVisible(true);
        TableColumn column = null;
        column = new TableColumn(this.tblRevision, 16384);
        column.setText("\u540d\u524d");
        column.setWidth(180);
        column = new TableColumn(this.tblRevision, 131072);
        column.setText("\u30ea\u30d3\u30b8\u30e7\u30f3");
        column.setWidth(76);
        column = new TableColumn(this.tblRevision, 131072);
        column.setText("\u30ea\u30d3\u30b8\u30e7\u30f3(\u6700\u7d42\u5909\u66f4)");
        column.setWidth(120);
        this.tblRevision.setSortColumn(column);
        column = new TableColumn(this.tblRevision, 16384);
        column.setText("\u5909\u66f4\u8005");
        column.setWidth(80);
        column = new TableColumn(this.tblRevision, 16384);
        column.setText("\u66f4\u65b0\u65e5\u6642");
        column.setWidth(180);
        column = new TableColumn(this.tblRevision, 16384);
        column.setText("\u683c\u7d0d\u30d1\u30b9(\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf)");
        column.setWidth(180);
        column = new TableColumn(this.tblRevision, 16384);
        column.setText("UUID");
        column.setWidth(240);
    }

    public ISVNFileItem getISVNFileItem() {
        return this.fileItem;
    }

    protected void PageComplete() {
        this.setErrorMessage(null);
        if (this.fileItem == null) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public IWizardPage getNextPage() {
        ExportWizardPage2 page2 = (ExportWizardPage2)this.getWizard().getPage("ExportWizardPage2");
        page2.setISVNFileItem(this.fileItem);
        return super.getNextPage();
    }
}

