/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view;

import com.interpress_project.modernshare.client.controller.actions.ExitAction;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.actions.StartupSyncAction;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.SVNFolderUtil;
import com.interpress_project.modernshare.client.controller.delegate.secureguard.SVNproxy;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventSource;
import com.interpress_project.modernshare.client.events.IGUIEventListener;
import com.interpress_project.modernshare.client.events.ILocalViewEventListener;
import com.interpress_project.modernshare.client.events.ILogEventListener;
import com.interpress_project.modernshare.client.events.IRemoteViewEventListener;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LocalViewEventSource;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.RemoteViewEvent;
import com.interpress_project.modernshare.client.events.RemoteViewEventSource;
import com.interpress_project.modernshare.client.view.DialogManager;
import com.interpress_project.modernshare.client.view.MfContents;
import com.interpress_project.modernshare.client.view.MfCoolBar;
import com.interpress_project.modernshare.client.view.MfMenuBar;
import com.interpress_project.modernshare.client.view.MfTaskTray;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ViewManager
extends ApplicationWindow
implements ILocalViewEventListener,
IRemoteViewEventListener,
ILogEventListener,
IGUIEventListener {
    private MfCoolBar aCoolBar;
    private static ViewManager instance;
    private final SystemBase sb = SystemBase.getInstance();
    private MfContents aContents;
    private DialogManager dlgmgr;
    private SVNproxy proxy = null;

    public ViewManager() {
        super(null);
        this.addMenuBar();
        this.addCoolBar(0x800040);
        this.addStatusLine();
    }

    public static ViewManager getInstance() {
        if (instance == null) {
            instance = new ViewManager();
        }
        return instance;
    }

    public void run() {
        this.setBlockOnOpen(true);
        this.open();
        Display.getCurrent().dispose();
    }

    public DialogManager getDialogManager() {
        return this.dlgmgr;
    }

    protected MenuManager createMenuManager() {
        return new MfMenuBar(this);
    }

    protected CoolBarManager createCoolBarManager(int style) {
        this.aCoolBar = new MfCoolBar(this, style);
        return this.aCoolBar;
    }

    protected StatusLineManager createStatusLineManager() {
        return new StatusLineManager();
    }

    protected void configureShell(final Shell shell) {
        super.configureShell(shell);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ViewManager.this.sb.getLogger().debug((Object)"Enter Housekeeping.");
                LogEventSource.getInstance().removeEventListener(ViewManager.getInstance());
                LocalViewEventSource.getInstance().removeEventListener(ViewManager.getInstance());
                RemoteViewEventSource.getInstance().removeEventListener(ViewManager.getInstance());
                GUIEventSource.getInstance().removeEventListener(ViewManager.getInstance());
                try {
                    ORBManager.getInstance().storeClientData();
                }
                catch (Exception ex) {
                    ViewManager.this.sb.getLogger().error((Object)("XML\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30e2\u30fc\u30c8\u4fdd\u5b58\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002: " + ex.getCause().getMessage()));
                }
                LocalModelManager lmmgr = LocalModelManager.getInstance();
                lmmgr.dispose();
                SVNCommandManager commandManager = SVNCommandManager.getInstance();
                commandManager.dispose();
                TaskManager taskmgr = TaskManager.getInstance();
                taskmgr.dispose();
                ImageFactory.getInstance().dispose();
                Rectangle rectangle = shell.getBounds();
                PropertyManager propmgr = PropertyManager.getInstance();
                propmgr.setFramePosition(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                propmgr.store();
                ViewManager.this.proxy.dispose();
                ViewManager.this.sb.getLogger().debug((Object)"Client terminated.");
            }
        });
        shell.addShellListener(new ShellListener(){

            public void shellActivated(ShellEvent arg0) {
            }

            public void shellClosed(ShellEvent arg0) {
            }

            public void shellDeactivated(ShellEvent arg0) {
            }

            public void shellDeiconified(ShellEvent arg0) {
            }

            public void shellIconified(ShellEvent e) {
                ((Shell)e.widget).setVisible(false);
            }
        });
    }

    protected Control createContents(Composite parent) {
        this.aContents = new MfContents(this, parent, 0);
        return parent;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        this.dlgmgr = new DialogManager(this);
        PropertyManager propmgr = PropertyManager.getInstance();
        String filename = propmgr.getPropFileName();
        if (!new File(filename).exists()) {
            String msg = "HotShot\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30a2\u30ab\u30a6\u30f3\u30c8\u60c5\u5831\u3068\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u60c5\u5831\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            if (!this.dlgmgr.createYesNoMessageDialog("HotShot\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u8a2d\u5b9a", msg)) {
                System.exit(-1);
                return;
            }
            this.dlgmgr.createPreferenceDialog();
        }
        int[] framepos = propmgr.getFramePosition();
        shell.setBounds(new Rectangle(framepos[0], framepos[1], framepos[2], framepos[3]));
        new MfTaskTray(this);
        this.getShell().setText("InterPress - HotShot");
        this.getShell().setImage(ImageFactory.getInstance().getImage("sync"));
        this.aCoolBar.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                ViewManager.this.aCoolBar.getControl().getParent().layout();
            }
        });
        LogEventSource.getInstance().addEventListener(this);
        LocalViewEventSource.getInstance().addEventListener(this);
        RemoteViewEventSource.getInstance().addEventListener(this);
        GUIEventSource.getInstance().addEventListener(this);
        this.proxy = new SVNproxy();
        this.proxy.start();
        ORBManager.getInstance();
        SVNFolderUtil.getInstance();
        SVNCommandManager commandManager = SVNCommandManager.getInstance();
        commandManager.start();
        LocalModelManager.getInstance();
        this.initialSyncTargets();
        TaskManager taskmgr = TaskManager.getInstance();
        taskmgr.start();
    }

    protected boolean canHandleShellCloseEvent() {
        ExitAction action = new ExitAction(this);
        action.run();
        return action.isTerminated();
    }

    private void initialSyncTargets() {
        final Shell shell = this.getShell();
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new StartupSyncAction(ViewManager.getInstance()).run();
                shell.setMinimized(true);
                shell.setVisible(false);
            }
        });
    }

    @Override
    public void EventArrived(LocalViewEvent event) {
        if (this.aContents != null) {
            this.aContents.updateLocalViewer(event);
        }
    }

    @Override
    public void EventArrived(RemoteViewEvent event) {
        if (this.aContents != null) {
            this.aContents.updateRemoteViewer(event);
        }
    }

    @Override
    public void EventArrived(LogEvent event) {
        if (this.aContents != null) {
            this.aContents.updateAppLog(event);
        }
    }

    @Override
    public void EventArrived(GUIEvent event) {
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        this.setStatus(event.getMessage());
        shell.update();
        switch (event.getGUIEventType()) {
            case START: {
                shell.setCursor(new Cursor(null, 1));
                break;
            }
            case FINISH: {
                shell.setCursor(new Cursor(null, 0));
            }
        }
    }
}

