/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view;

import com.interpress_project.modernshare.client.controller.actions.ExitAction;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.view.ViewManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public final class MfTaskTray {
    private final Shell shell;

    public MfTaskTray(final ViewManager vmgr) {
        this.shell = vmgr.getShell();
        Tray tray = this.shell.getDisplay().getSystemTray();
        TrayItem trayItem = new TrayItem(tray, 0);
        trayItem.setToolTipText("InterPress Hot Shot client agent");
        trayItem.setImage(ImageFactory.getInstance().getImage("sync"));
        trayItem.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                MfTaskTray.this.NormalizeWindowHSCC();
            }
        });
        trayItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                TrayItem trayItem = (TrayItem)disposeEvent.getSource();
                trayItem.getImage().dispose();
            }
        });
        final Menu menu = new Menu((Decorations)this.shell, 8);
        MenuItem menuOpen = new MenuItem(menu, 8);
        menuOpen.setText("HotShot\u30b3\u30f3\u30bd\u30fc\u30eb\u3092\u958b\u304f(&O)");
        menuOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MfTaskTray.this.NormalizeWindowHSCC();
            }
        });
        MenuItem menuMinimum = new MenuItem(menu, 8);
        menuMinimum.setText("\u6700\u5c0f\u5316(&C)");
        menuMinimum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MfTaskTray.this.MinimizeWindowHSCC();
            }
        });
        new MenuItem(menu, 2);
        MenuItem menuExit = new MenuItem(menu, 8);
        menuExit.setText("\u7d42\u4e86(&X)");
        menuExit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ExitAction(vmgr).run();
            }
        });
        trayItem.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                menu.setVisible(true);
            }
        });
    }

    private void NormalizeWindowHSCC() {
        this.shell.setMinimized(false);
        this.shell.setVisible(true);
    }

    private void MinimizeWindowHSCC() {
        this.shell.setMinimized(true);
        this.shell.setVisible(false);
    }
}

