/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.castor.Configure;
import com.interpress_project.modernshare.client.controller.model.castor.Target;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.exolab.castor.util.LocalConfiguration;

public class XmlDAOManager {
    private SystemBase sb = SystemBase.getInstance();
    private final PropertyManager propmgr = PropertyManager.getInstance();
    private Configure configure = new Configure();
    private boolean bXMLLoaded = false;
    private boolean bNeedXMLSave = false;

    public XmlDAOManager() {
        Properties props = LocalConfiguration.getInstance().getProperties();
        props.setProperty("org.exolab.castor.parser", "org.apache.xerces.parsers.SAXParser");
        props.setProperty("org.exolab.castor.serializer", "org.apache.xml.serialize.XMLSerializer");
        props.setProperty("org.exolab.castor.regexp", "org.exolab.castor.util.JakartaRegExpEvaluator");
        props.setProperty("org.exolab.castor.indent", "true");
        props.setProperty("org.exolab.castor.parser.validation", "false");
        props.setProperty("org.exolab.castor.parser.namespaces", "false");
        props.setProperty("org.exolab.castor.marshalling.validation", "true");
        props.setProperty("org.exolab.castor.debug", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.sb.getLogger().debug((Object)"Enter load() in XMLDAOManager.");
        InputStreamReader isr = null;
        try {
            FileInputStream fis = new FileInputStream(this.propmgr.getXMLFileName());
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            this.configure = Configure.unmarshal(isr);
            this.bXMLLoaded = true;
        }
        catch (Exception e) {
            this.sb.getLogger().warn((Object)"Fail to load XML file, create new one.");
        }
        finally {
            try {
                isr.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void save() {
        this.sb.getLogger().debug((Object)"Enter save() in XMLDAOManager.");
        try {
            FileOutputStream fos = new FileOutputStream(this.sb.getUserHomeDirectory() + "/" + "HotShotClient.xml");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            this.configure.marshal(osw);
            osw.close();
        }
        catch (Exception ex) {
            this.sb.getLogger().warn((Object)"Fail to save XML file, create new one.", (Throwable)ex);
        }
    }

    public LocalRoot[] getLocalRoots() {
        ArrayList<LocalRoot> list = new ArrayList<LocalRoot>();
        Target[] targets = this.configure.getTarget();
        for (int i = 0; i < targets.length; ++i) {
            String folder = targets[i].getFolder();
            String tagname = targets[i].getTagname();
            RootStatus status = null;
            status = new File(folder).exists() ? RootStatus.valueOf(targets[i].getStatus()) : RootStatus.disable;
            boolean direction = targets[i].getPc2host();
            LocalRoot localRoot = new LocalRoot(folder, tagname, status, direction);
            list.add(localRoot);
        }
        return list.toArray(new LocalRoot[list.size()]);
    }

    public void setLocalRoots(LocalRoot[] localRoots) {
        this.configure.removeAllTarget();
        for (int i = 0; i < localRoots.length; ++i) {
            Target target = new Target();
            target.setFolder(localRoots[i].getAbsolutePath());
            if (new File(localRoots[i].getAbsolutePath()).exists()) {
                target.setStatus(localRoots[i].getStatus().name());
            } else {
                target.setStatus(RootStatus.disable.name());
            }
            target.setTagname(localRoots[i].getName());
            target.setPc2host(localRoots[i].getPc2host());
            this.configure.addTarget(target);
        }
    }

    public boolean hasXMLLoaded() {
        return this.bXMLLoaded;
    }

    public boolean needXMLSave() {
        return this.bNeedXMLSave;
    }

    public void needXMLSave(boolean b) {
        this.bNeedXMLSave = b;
    }
}

