/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.preference.PreferenceStore;

public class PropertyManager
extends PreferenceStore {
    private SystemBase sb = SystemBase.getInstance();
    private String fileName = null;
    private static PropertyManager instance;

    private PropertyManager() {
        this.setDefault("hotshot.client.system.X", "0");
        this.setDefault("hotshot.client.system.Y", "0");
        this.setDefault("hotshot.client.system.W", "640");
        this.setDefault("hotshot.client.system.H", "480");
        this.setDefault("hotshot.server.host", "localhost");
        this.setDefault("hotshot.server.port", "17770");
        this.setDefault("hotshot.server.username", "anonymous");
        String result = this.sb.getSystemUtil().crypt("striketwice", "anonymous@localhost");
        this.setDefault("hotshot.server.password", result);
        try {
            InetAddress inet = InetAddress.getLocalHost();
            String name = inet.getHostName();
            this.setDefault("hotshot.client.id", name);
        }
        catch (UnknownHostException ex) {
            this.sb.getLogger().fatal((Object)"\u30ed\u30fc\u30ab\u30eb\u30db\u30b9\u30c8\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            this.sb.getLogger().fatal((Object)"\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
            System.exit(-1);
        }
        this.setDefault("hotshot.client.sghost", "127.0.0.1");
        this.setDefault("hotshot.client.sgport", "65321");
        this.setDefault("hotshot.server.svnserver.port", 3690);
        this.setDefault("hotshot.client.duration", 3);
        this.setDefault("hotshot.client.direction.pc2host", "true");
        this.setDefault("hotshot.client.maxcache", 12);
        this.setDefault("hotshot.client.ignorefilter", "*.bak *.swp ~$*.* ~*.tmp *.$$$  README_HotShotFolder.txt *.hotshot-safestore");
        this.setDefault("hotshot.server.licensetype", "PERSONAL");
        this.setDefault("hotshot.network.tcpbufsz", 32768);
        this.setDefault("hotshot.network.connectiontimeout", 4000);
        this.setDefault("hotshot.network.ssl.keystore.file", "jsse_client_ks");
        this.setDefault("hotshot.network.ssl.keystore.password", "jsse_client_ks_pass");
        this.fileName = this.sb.getUserHomeDirectory() + "/" + "HotShotClient.properties";
        this.setFilename(this.fileName);
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PropertyManager getInstance() {
        if (instance == null) {
            instance = new PropertyManager();
        }
        return instance;
    }

    public void store() {
        try {
            if (this.needsSaving()) {
                this.save();
            }
        }
        catch (IOException ex) {
            this.sb.getLogger().warn((Object)"IOException saving properties into the file, HotShotClient.properties", (Throwable)ex);
        }
    }

    public void setFramePosition(int x, int y, int w, int h) {
        this.setValue("hotshot.client.system.X", x);
        this.setValue("hotshot.client.system.Y", y);
        this.setValue("hotshot.client.system.W", w);
        this.setValue("hotshot.client.system.H", h);
    }

    public int[] getFramePosition() {
        int x = this.getInt("hotshot.client.system.X");
        int y = this.getInt("hotshot.client.system.Y");
        int w = this.getInt("hotshot.client.system.W");
        int h = this.getInt("hotshot.client.system.H");
        int[] pos = new int[]{x, y, w, h};
        return pos;
    }

    public String getUsername() {
        return this.getString("hotshot.server.username");
    }

    public void setUsername(String name) {
        this.setValue("hotshot.server.username", name);
    }

    public String getPassword() {
        String p = this.getString("hotshot.server.password");
        String result = this.sb.getSystemUtil().decrypt("striketwice", p);
        return result;
    }

    public void setPassword(String password) {
        String result = this.sb.getSystemUtil().crypt("striketwice", password);
        this.setValue("hotshot.server.password", result);
    }

    public String getTargetSVNURL(String account) {
        String url = "svn://" + this.getSecureGuardHost() + ":" + this.getSecureGuardPort() + "/" + account;
        return url;
    }

    public String getTargetSVNURL() {
        String url = "svn://" + this.getSecureGuardHost() + ":" + this.getSecureGuardPort() + "/";
        return url;
    }

    public String getTargetCorbaloc() {
        String url = "corbaloc:ssliop:1.2@" + this.getAdminHost() + ":" + String.valueOf(this.getAdminPort()) + "/StandardImplName/MyFactory_poa/MyFactory";
        return url;
    }

    public String getAdminHost() {
        return this.getString("hotshot.server.host");
    }

    public int getAdminPort() {
        return this.getInt("hotshot.server.port");
    }

    public String getSVNHost() {
        return this.getAdminHost();
    }

    public void setSVNHost(String host) {
        this.setValue("hotshot.server.host", host);
    }

    public int getSVNPort() {
        return this.getInt("hotshot.server.svnserver.port");
    }

    public void setSVNPort(int port) {
        this.setValue("hotshot.server.svnserver.port", port);
    }

    public String getSecureGuardHost() {
        return this.getString("hotshot.client.sghost");
    }

    public void setSecureGuardPort(int port) {
        this.setValue("hotshot.client.sgport", port);
    }

    public int getSecureGuardPort() {
        return this.getInt("hotshot.client.sgport");
    }

    public int getDuration() {
        return this.getInt("hotshot.client.duration");
    }

    public void setDuration(int duration) {
        this.setValue("hotshot.client.duration", duration);
    }

    public boolean isPc2Host() {
        return this.getBoolean("hotshot.client.direction.pc2host");
    }

    public void setPc2Host(boolean b) {
        this.setValue("hotshot.client.direction.pc2host", b);
    }

    public void setMaxCache(int c) {
        this.setValue("hotshot.client.maxcache", c);
    }

    public int getMaxCache() {
        return this.getInt("hotshot.client.maxcache");
    }

    public int getTcpBufSz() {
        return this.getInt("hotshot.network.tcpbufsz");
    }

    public String[] getIgnoreFilterList() {
        ArrayList<String> list = new ArrayList<String>();
        String f = this.getString("hotshot.client.ignorefilter");
        StringTokenizer st = new StringTokenizer(f, " ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            list.add(s);
        }
        list.trimToSize();
        return list.toArray(new String[list.size()]);
    }

    public void setConnectionTimeout(int value) {
        this.setValue("hotshot.network.connectiontimeout", value);
    }

    public int getConnectionTimeout() {
        return this.getInt("hotshot.network.connectiontimeout");
    }

    public void setKeystore(String s) {
        this.setValue("hotshot.network.ssl.keystore.file", s);
    }

    public String getKeystore() {
        return this.getString("hotshot.network.ssl.keystore.file");
    }

    public void setKeystorePass(String s) {
        this.setValue("hotshot.network.ssl.keystore.password", s);
    }

    public String getKeystorePass() {
        return this.getString("hotshot.network.ssl.keystore.password");
    }

    public void setClientId(String s) {
        this.setValue("hotshot.client.id", s);
    }

    public String getClientId() {
        return this.getString("hotshot.client.id");
    }

    public String getXMLFileName() {
        String path = this.sb.getUserHomeDirectory() + "/" + "HotShotClient.xml";
        return FilenameUtils.normalize((String)path);
    }

    public String getPropFileName() {
        return this.fileName;
    }
}

