/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.model.IFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalFile;
import java.io.File;
import java.util.ArrayList;

public class LocalFolder
implements IFileItem {
    private File file;

    public LocalFolder(String path) {
        this.file = new File(path);
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public long getFilesize() {
        return 0L;
    }

    @Override
    public IFileItem[] getLocalItems() {
        if (!this.isExist()) {
            return null;
        }
        ArrayList<IFileItem> arrayList = new ArrayList<IFileItem>(12);
        File[] files = this.file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                arrayList.add(new LocalFolder(files[i].getAbsolutePath()));
                continue;
            }
            arrayList.add(new LocalFile(files[i].getAbsolutePath()));
        }
        return arrayList.toArray(new IFileItem[arrayList.size()]);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public IFileItem getParent() {
        String parent = this.file.getParent();
        if (parent == null) {
            return null;
        }
        return new LocalFolder(parent);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isExist() {
        return this.file.exists();
    }
}

