/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate.secureguard;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class WorkerThread
implements Runnable {
    private final SystemBase sb = SystemBase.getInstance();
    private Socket requestSocket = null;
    private SSLSocket tgtSocket = null;
    private BufferedInputStream sock_bis = null;
    private BufferedInputStream svnsock_bis = null;
    private BufferedOutputStream sock_bos = null;
    private BufferedOutputStream svnsock_bos = null;
    private String targethost;
    private int targetport;
    private int tcpbufsz;
    private int conntimeout;
    private final int bufsz = 32768;
    private boolean bDoneIn = false;
    private boolean bDoneOut = false;
    private ThreadPoolExecutor workThreadPool = null;
    private static SSLContext context = null;

    public WorkerThread(Socket socket, String host, int port, ThreadPoolExecutor workThreadPool, int tcpbufsz, int conntimeout) {
        this.requestSocket = socket;
        this.targethost = host;
        this.targetport = port;
        this.workThreadPool = workThreadPool;
        this.tcpbufsz = tcpbufsz;
        this.conntimeout = conntimeout;
        try {
            this.requestSocket.setSendBufferSize(tcpbufsz);
            this.requestSocket.setKeepAlive(true);
            this.requestSocket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLContext getSSLContext(String trustedKeyStoreFile, String keyStoreType, String trustedKeyStorePass) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType != null ? keyStoreType : KeyStore.getDefaultType());
        FileInputStream in = new FileInputStream(trustedKeyStoreFile);
        try {
            keyStore.load(new FileInputStream(trustedKeyStoreFile), trustedKeyStorePass.toCharArray());
        }
        finally {
            in.close();
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        TrustManager[] tm = tmf.getTrustManagers();
        SSLContext context = SSLContext.getInstance("SSL");
        context.init(null, tm, null);
        return context;
    }

    private void connect_server(String hostname, int port) throws SocketException, IOException, KeyManagementException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (context == null) {
            context = this.getSSLContext("jsse_client_ks", null, "jsse_client_ks_pass");
        }
        InetSocketAddress endpoint = new InetSocketAddress(hostname, port);
        this.tgtSocket = (SSLSocket)context.getSocketFactory().createSocket();
        this.tgtSocket.setReceiveBufferSize(this.tcpbufsz);
        this.tgtSocket.setSendBufferSize(this.tcpbufsz);
        this.tgtSocket.setKeepAlive(true);
        this.tgtSocket.setTcpNoDelay(true);
        this.tgtSocket.connect(endpoint, this.conntimeout);
        this.svnsock_bis = new BufferedInputStream(this.tgtSocket.getInputStream(), this.tcpbufsz);
        this.svnsock_bos = new BufferedOutputStream(this.tgtSocket.getOutputStream(), this.tcpbufsz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._run();
        }
        finally {
            try {
                if (this.sock_bis != null) {
                    this.sock_bis.close();
                }
                if (this.sock_bos != null) {
                    this.sock_bos.close();
                }
                this.requestSocket.close();
                this.requestSocket = null;
            }
            catch (IOException ex) {
                this.sb.getLogger().error((Object)("requestSocket closing failed: " + ex.toString()));
            }
            try {
                if (this.svnsock_bis != null) {
                    this.svnsock_bis.close();
                }
                if (this.svnsock_bos != null) {
                    this.svnsock_bos.close();
                }
                this.tgtSocket.close();
                this.tgtSocket = null;
            }
            catch (IOException ex) {
                this.sb.getLogger().error((Object)("tgtSocket closing failed: " + ex.toString()));
            }
            this.sb.getLogger().debug((Object)"Connection accepted from SVNAdapter done!");
        }
    }

    private void _run() {
        try {
            this.connect_server(this.targethost, this.targetport);
        }
        catch (SocketTimeoutException ex) {
            this.sb.getLogger().error((Object)("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3078\u306e\u63a5\u7d9a\u6642\u306b\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002(\u30bb\u30ad\u30e5\u30a2\u30ac\u30fc\u30c9) (\u30db\u30b9\u30c8\u540d: " + this.targethost + ", \u30dd\u30fc\u30c8: " + this.targetport + ")"));
            return;
        }
        catch (Exception ex) {
            this.sb.getLogger().error((Object)("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(\u30bb\u30ad\u30e5\u30a2\u30ac\u30fc\u30c9) (\u30db\u30b9\u30c8\u540d: " + this.targethost + ", \u30dd\u30fc\u30c8: " + this.targetport + ":" + ex.toString() + ")"));
            return;
        }
        try {
            this.sock_bis = new BufferedInputStream(this.requestSocket.getInputStream(), this.tcpbufsz);
            this.sock_bos = new BufferedOutputStream(this.requestSocket.getOutputStream(), this.tcpbufsz);
        }
        catch (IOException ex) {
            this.sb.getLogger().error((Object)"WorkerThread() caught exception : ", (Throwable)ex);
            return;
        }
        this.workThreadPool.execute(new StreamGobblerSrc2Dest(this.sock_bis, this.svnsock_bos));
        this.workThreadPool.execute(new StreamGobblerDest2Src(this.svnsock_bis, this.sock_bos));
        while (!this.bDoneIn || !this.bDoneOut) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class StreamGobblerDest2Src
    implements Runnable {
        private BufferedInputStream bis = null;
        private BufferedOutputStream bos = null;

        public StreamGobblerDest2Src(BufferedInputStream bis, BufferedOutputStream bos) {
            this.bis = bis;
            this.bos = bos;
        }

        public void setStreams(BufferedInputStream bis, BufferedOutputStream bos) {
            this.bis = bis;
            this.bos = bos;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[32768];
            try {
                int len;
                while ((len = this.bis.read(buffer, 0, 32768)) != -1) {
                    this.bos.write(buffer, 0, len);
                    this.bos.flush();
                }
            }
            catch (SocketException ex) {
                WorkerThread.this.sb.getLogger().debug((Object)("(IGNORABLE) " + ex.toString()));
            }
            catch (IOException ex) {
                WorkerThread.this.sb.getLogger().error((Object)("\u901a\u4fe1\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002: " + ex.getCause().getMessage()));
            }
            WorkerThread.this.bDoneOut = true;
        }
    }

    private class StreamGobblerSrc2Dest
    implements Runnable {
        private BufferedInputStream bis = null;
        private BufferedOutputStream bos = null;

        public StreamGobblerSrc2Dest(BufferedInputStream bis, BufferedOutputStream bos) {
            this.bis = bis;
            this.bos = bos;
        }

        public void setStreams(BufferedInputStream bis, BufferedOutputStream bos) {
            this.bis = bis;
            this.bos = bos;
        }

        private void flushBuffer(ByteBuffer buffer, int sz) throws Exception {
            if (sz > 0) {
                this.bos.write(buffer.array(), 0, sz);
                this.bos.flush();
                buffer.clear();
            }
        }

        @Override
        public void run() {
            boolean bClosed = false;
            ByteBuffer buffer = ByteBuffer.allocate(32768);
            int i = 0;
            int c = 0;
            do {
                for (i = 0; i < 32768; ++i) {
                    try {
                        if (this.bis.available() == 0) {
                            this.flushBuffer(buffer, i);
                            i = 0;
                        }
                        c = this.bis.read();
                    }
                    catch (SocketException ex) {
                        bClosed = true;
                        WorkerThread.this.sb.getLogger().debug((Object)("(IGNORABLE) " + ex.toString()));
                        break;
                    }
                    catch (Exception ex) {
                        bClosed = true;
                        WorkerThread.this.sb.getLogger().error((Object)"Exception caught in StreamGobblerSrc2Dest(): ", (Throwable)ex);
                        break;
                    }
                    if (c == -1) {
                        bClosed = true;
                        break;
                    }
                    buffer.put(i, (byte)c);
                }
                try {
                    this.flushBuffer(buffer, i);
                }
                catch (Exception ex) {
                    bClosed = true;
                    WorkerThread.this.sb.getLogger().error((Object)ex);
                }
            } while (!bClosed);
            try {
                this.bos.close();
            }
            catch (IOException ex) {
                WorkerThread.this.sb.getLogger().error((Object)ex);
            }
            WorkerThread.this.bDoneIn = true;
        }
    }
}

