/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate.secureguard;

import com.interpress_project.modernshare.client.controller.delegate.secureguard.WorkerThread;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SVNproxy
extends Thread {
    private final SystemBase sb = SystemBase.getInstance();
    private final PropertyManager propmgr = PropertyManager.getInstance();
    private int THREAD_INITIALCOUNT = 16;
    private int THREAD_MAXCOUNT = 32;
    private int LISTEN_PORT = this.propmgr.getSecureGuardPort();
    private ServerSocket serverSocket = null;
    private ThreadPoolExecutor requestThreadPool = null;
    private ThreadPoolExecutor workThreadPool = null;
    private InetAddress hostaddr = null;
    private boolean shutdown = false;

    public SVNproxy() {
        try {
            this.hostaddr = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException ex) {
            this.sb.getLogger().fatal((Object)"\u30ed\u30fc\u30ab\u30eb\u30eb\u30fc\u30d7\u30d0\u30c3\u30af\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.requestThreadPool = new ThreadPoolExecutor(this.THREAD_INITIALCOUNT, this.THREAD_MAXCOUNT, 180L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.workThreadPool = new ThreadPoolExecutor(this.THREAD_INITIALCOUNT, this.THREAD_MAXCOUNT, 180L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.setReceiveBufferSize(this.propmgr.getTcpBufSz());
            this.serverSocket.setReuseAddress(false);
            this.serverSocket.setSoTimeout(30000);
            InetSocketAddress endpoint = new InetSocketAddress(this.hostaddr, this.LISTEN_PORT);
            this.serverSocket.bind(endpoint, 32);
        }
        catch (IOException ex) {
            this.requestThreadPool.shutdown();
            this.sb.getLogger().fatal((Object)"\u30bb\u30ad\u30e5\u30a2\u30ac\u30fc\u30c9\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002", (Throwable)ex);
            System.exit(-1);
        }
    }

    public void dispose() {
        this.shutdown = true;
        this.interrupt();
        this.requestThreadPool.shutdownNow();
        this.workThreadPool.shutdownNow();
        try {
            Socket clientSocket = new Socket("127.0.0.1", this.LISTEN_PORT);
            clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        int tcpbufsz = 0;
        int timeout = 0;
        this.sb.getLogger().debug((Object)("Secure guard port: " + this.LISTEN_PORT));
        this.sb.getLogger().debug((Object)("Secure guard svn host: " + this.propmgr.getSVNHost()));
        this.sb.getLogger().debug((Object)("Secure guard svn port: " + this.propmgr.getSVNPort()));
        try {
            tcpbufsz = this.serverSocket.getReceiveBufferSize();
            this.sb.getLogger().debug((Object)("Secure guard buffer size: " + tcpbufsz + "(byte)"));
        }
        catch (SocketException ex) {
            // empty catch block
        }
        timeout = this.propmgr.getConnectionTimeout();
        this.sb.getLogger().debug((Object)("Secure guard thread pool(min): " + this.THREAD_INITIALCOUNT));
        this.sb.getLogger().debug((Object)("Secure gurad thread pool(max): " + this.THREAD_MAXCOUNT));
        this.sb.getLogger().debug((Object)"Secure guard started.");
        while (!this.shutdown) {
            try {
                Socket socket = this.serverSocket.accept();
                this.sb.getLogger().debug((Object)"Connection accepted from SVNAdapter...");
                this.requestThreadPool.execute(new WorkerThread(socket, this.propmgr.getSVNHost(), this.propmgr.getSVNPort(), this.workThreadPool, tcpbufsz, timeout));
            }
            catch (Exception ex) {}
        }
        this.sb.getLogger().debug((Object)"\u30bb\u30ad\u30e5\u30a2\u30ac\u30fc\u30c9\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
    }
}

