/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.DeleteFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.RenameFailException;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class SVNFolderUtil {
    private ArrayList<File> list1 = null;
    private ArrayList<File> list2 = null;
    private File rootFolder;
    private final LogEventSource logEventSource = LogEventSource.getInstance();
    private final SystemBase sb = SystemBase.getInstance();

    private SVNFolderUtil() {
    }

    public ArrayList<File> getSVNDirListInTarget(File folder) {
        this.rootFolder = folder;
        this.list1 = new ArrayList(64);
        this._getSVNDirList(this.rootFolder);
        this.list1.trimToSize();
        return this.list1;
    }

    private void _getSVNDirList(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                this._getSVNDirList(new File(dir, children[i]));
            }
        }
        if (dir.getName().equalsIgnoreCase(".svn")) {
            this.list1.add(dir);
        }
    }

    public ArrayList<File> getDirListInTarget(File folder) {
        this.list2 = new ArrayList(64);
        File[] files = folder.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this._getDirList(files[i]);
        }
        Collections.sort(this.list2);
        this.list2.trimToSize();
        return this.list2;
    }

    private void _getDirList(File dir) {
        if (dir.isDirectory()) {
            if (dir.getName().equalsIgnoreCase(".svn")) {
                return;
            }
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                this._getDirList(new File(dir, children[i]));
            }
            this.list2.add(dir);
        }
    }

    public void deleteFiles(ArrayList<File> list) throws DeleteFailException {
        for (int i = 0; i < list.size(); ++i) {
            File file = list.get(i);
            this.deleteFile(file);
        }
    }

    public void deleteFile(File dir) throws DeleteFailException {
        if (!dir.exists()) {
            return;
        }
        try {
            if (dir.isDirectory()) {
                FileUtils.deleteDirectory((File)dir);
            } else {
                FileUtils.forceDelete((File)dir);
            }
        }
        catch (IOException ex) {
            throw new DeleteFailException("\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb" + dir.getAbsolutePath() + "\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        this.logEventSource.fireEvent(new LogEvent(this, dir.getAbsolutePath() + "\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002", LogEventType.INFO));
    }

    public void deleteSVNFolders(File file) throws DeleteFailException {
        ArrayList<File> list = this.getSVNDirListInTarget(file);
        this.deleteFiles(list);
    }

    public void renameFile(File src, File dest) throws RenameFailException {
        if (!src.renameTo(dest)) {
            throw new RenameFailException(src.getAbsolutePath() + "\u304b\u3089" + dest.getAbsolutePath() + "\u3078\u306e\u540d\u524d\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        this.logEventSource.fireEvent(new LogEvent(this, src.getAbsolutePath() + "\u3092" + dest.getAbsolutePath() + "\u306b\u540d\u524d\u5909\u66f4\u3092\u3057\u307e\u3057\u305f\u3002", LogEventType.INFO));
    }

    public void renameBkupFile(File src) throws RenameFailException {
        String bkuppath = src.getAbsolutePath();
        String date = this.sb.getDateUtil().getDateTimeAsFullString(new Date());
        date = date.replaceAll(" ", "");
        File bkupfile = new File(bkuppath = bkuppath + "." + date + "." + "hotshot-safestore");
        if (!src.renameTo(bkupfile)) {
            throw new RenameFailException(src.getAbsolutePath() + "\u304b\u3089" + bkupfile.getAbsolutePath() + "\u3078\u306e\u540d\u524d\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        this.logEventSource.fireEvent(new LogEvent(this, src.getAbsolutePath() + "\u3092" + bkupfile.getAbsolutePath() + "\u306b\u540d\u524d\u5909\u66f4\u3092\u3057\u307e\u3057\u305f\u3002", LogEventType.INFO));
    }

    public static SVNFolderUtil getInstance() {
        return new SVNFolderUtil();
    }
}

