/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountExistException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.LicenseException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoPermissionException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.UnknownHostException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.orb.MdsClientInfoFactory;
import com.interpress_project.modernshare.orb.MdsClientInfoImpl;
import com.interpress_project.modernshare.orb.MdsServerInfoFactory;
import com.interpress_project.modernshare.orb.generated.AccountExist;
import com.interpress_project.modernshare.orb.generated.AccountNotFound;
import com.interpress_project.modernshare.orb.generated.InternalError;
import com.interpress_project.modernshare.orb.generated.LicenseError;
import com.interpress_project.modernshare.orb.generated.MdsClientInfo;
import com.interpress_project.modernshare.orb.generated.MdsClientInfoHelper;
import com.interpress_project.modernshare.orb.generated.MdsServerInfo;
import com.interpress_project.modernshare.orb.generated.MdsServerInfoHelper;
import com.interpress_project.modernshare.orb.generated.MdsService;
import com.interpress_project.modernshare.orb.generated.MdsServiceHelper;
import com.interpress_project.modernshare.orb.generated.NoPrivilege;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.Properties;
import org.jacorb.security.sas.GssUpContext;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;

public class ORBManager {
    private final SystemBase sb = SystemBase.getInstance();
    private final PropertyManager propmgr = PropertyManager.getInstance();
    private Properties props = System.getProperties();
    private ORB orb = null;
    private MdsService service = null;
    private String corbaurl;
    private static ORBManager instance;

    protected ORBManager() {
        this.props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        this.props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        this.props.setProperty("custom.props", "etc/jacorb.properties");
        this.props.setProperty("jacorb.suppress_no_props_warning", "on");
        this.props.setProperty("jacorb.security.sas.contextClass", "org.jacorb.security.sas.GssUpContext");
        this.props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.SAS", "org.jacorb.security.sas.SASInitializer");
        this.props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.GSSUPProvider", "org.jacorb.security.sas.GSSUPProviderInitializer");
        this.props.setProperty("jacorb.security.keystore", this.propmgr.getKeystore());
        this.props.setProperty("jacorb.security.keystore_password", this.propmgr.getKeystorePass());
    }

    public static ORBManager getInstance() {
        if (instance == null) {
            instance = new ORBManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSVNServerInfo() throws NoPermissionException, ConnectionFailException, UnknownHostException {
        try {
            this._connect(this.propmgr.getUsername(), this.propmgr.getPassword());
            this._updateSVNServerInfo();
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientData() throws NoPermissionException, UnknownHostException, ConnectionFailException {
        LocalModelManager lmmgr = LocalModelManager.getInstance();
        try {
            if (!lmmgr.hasXMLLoaded()) {
                this.sb.getLogger().debug((java.lang.Object)"Need load Config XML file from the remote.");
                this._connect(this.propmgr.getUsername(), this.propmgr.getPassword());
                this._updateClientData(this.propmgr.getUsername(), this.propmgr.getClientId());
                lmmgr.needXMLSave(false);
            }
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeClientData() throws NoPermissionException, ConnectionFailException, UnknownHostException {
        LocalModelManager lmmgr = LocalModelManager.getInstance();
        try {
            if (lmmgr.needXMLSave()) {
                this.sb.getLogger().debug((java.lang.Object)"Need remote store of Config XML file.");
                this._connect(this.propmgr.getUsername(), this.propmgr.getPassword());
                this._storeClientData(this.propmgr.getUsername(), this.propmgr.getClientId());
                lmmgr.needXMLSave(false);
            }
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAccount(String rootaccount, String rootpassword, String account, String password) throws NoPermissionException, ConnectionFailException, UnknownHostException, InternalFailException, AccountExistException, LicenseException {
        try {
            this._connect(rootaccount, rootpassword);
            this._updateSVNServerInfo();
            this._createAccount(account, password);
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAccount(String rootaccount, String rootpassword, String account) throws NoPermissionException, ConnectionFailException, UnknownHostException, InternalFailException, AccountNotFoundException {
        try {
            this._connect(rootaccount, rootpassword);
            this._updateSVNServerInfo();
            this._deleteAccount(account);
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String rootaccount, String rootpassword, String account, String newpassword) throws NoPermissionException, ConnectionFailException, UnknownHostException, AccountNotFoundException {
        try {
            this._connect(rootaccount, rootpassword);
            this._updateSVNServerInfo();
            this._changePassword(account, newpassword);
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String backup(String rootaccount, String rootpassword) throws NoPermissionException, ConnectionFailException, UnknownHostException, InternalFailException {
        String path = null;
        try {
            this._connect(rootaccount, rootpassword);
            this._updateSVNServerInfo();
            path = this._backup();
        }
        finally {
            this.disconnect();
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recovery(String rootaccount, String rootpassword) throws NoPermissionException, ConnectionFailException, UnknownHostException, InternalFailException {
        try {
            this._connect(rootaccount, rootpassword);
            this._updateSVNServerInfo();
            this._recovery();
        }
        finally {
            this.disconnect();
        }
    }

    private void _connect(String account, String password) throws NoPermissionException, ConnectionFailException, UnknownHostException {
        this.sb.getLogger().debug((java.lang.Object)"Enter ORBManager.connect()");
        try {
            this.orb = (ORB)ORB.init((String[])new String[]{""}, (Properties)this.props);
            this.orb.register_value_factory(MdsServerInfoHelper.id(), (ValueFactory)new MdsServerInfoFactory());
            this.orb.register_value_factory(MdsClientInfoHelper.id(), (ValueFactory)new MdsClientInfoFactory());
        }
        catch (Exception ex) {
            throw new ConnectionFailException("ORB\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002: " + ex.getMessage());
        }
        GssUpContext.setUsernamePassword((String)account, (String)password);
        try {
            InetAddress.getByName(this.propmgr.getAdminHost());
        }
        catch (java.net.UnknownHostException ex) {
            throw new UnknownHostException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u540d" + this.propmgr.getAdminHost() + "\u306e\u30a2\u30c9\u30ec\u30b9\u304c\u4e0d\u660e\u3067\u3059\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u540d\u304c\u6b63\u3057\u3044\u304b\u78ba\u8a8d\u3092\u3057\u3066\u304f\u3060\u3055\u3044\u3002", ex);
        }
        this.corbaurl = this.propmgr.getTargetCorbaloc();
        Object obj = this.orb.string_to_object(this.corbaurl);
        try {
            this.service = MdsServiceHelper.narrow((Object)obj);
        }
        catch (TRANSIENT ex) {
            throw new ConnectionFailException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf" + this.propmgr.getAdminHost() + "\u3078\u63a5\u7d9a\u4e2d\u306bORB\u3067\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30db\u30b9\u30c8\u60c5\u5831\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", ex);
        }
        catch (NO_PERMISSION ex) {
            throw new NoPermissionException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3078\u306eORB\u30a2\u30af\u30bb\u30b9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30a2\u30ab\u30a6\u30f3\u30c8/\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", ex);
        }
        catch (COMM_FAILURE ex) {
            throw new ConnectionFailException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf" + this.propmgr.getAdminHost() + "\u3068\u306e\u901a\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getMessage() + ")", ex);
        }
    }

    private void _updateSVNServerInfo() {
        this.sb.getLogger().debug((java.lang.Object)"Enter updateSVNInfo()");
        MdsServerInfo info = this.service.getServerInfo();
        this.sb.getLogger().debug((java.lang.Object)"Leaving updateSVNInfo()");
    }

    private void _updateClientData(String account, String clientid) {
        this.sb.getLogger().debug((java.lang.Object)"Enter getClientData()");
        MdsClientInfo info = this.service.getClientInfo(account, clientid);
        String xmldata = info.getXMLdata();
        try {
            FileOutputStream fos = new FileOutputStream(this.propmgr.getXMLFileName());
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(xmldata);
            bw.close();
        }
        catch (Exception ex) {
            this.sb.getLogger().error((java.lang.Object)"Exception writing XML file : ", (Throwable)ex);
            return;
        }
        LocalModelManager.getInstance().load();
        this.sb.getLogger().debug((java.lang.Object)"Leave getClientData()");
    }

    private void _storeClientData(String account, String clientid) {
        this.sb.getLogger().debug((java.lang.Object)"Enter setClientData()");
        StringBuffer strbuff = new StringBuffer();
        try {
            FileInputStream fis = new FileInputStream(this.propmgr.getXMLFileName());
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String str = null;
            while ((str = br.readLine()) != null) {
                strbuff.append(str);
            }
        }
        catch (Exception ex) {
            this.sb.getLogger().error((java.lang.Object)"Exception reading XML file: ", (Throwable)ex);
            return;
        }
        this.service.setClientInfo((MdsClientInfo)new MdsClientInfoImpl(account, clientid, strbuff.toString()));
        this.sb.getLogger().debug((java.lang.Object)"Leave setClientData()");
    }

    private void _createAccount(String account, String password) throws InternalFailException, NoPermissionException, AccountExistException, LicenseException {
        this.sb.getLogger().debug((java.lang.Object)("Enter ORBManager.createAccount(" + account + ")"));
        try {
            this.service.addUser(account, password);
        }
        catch (InternalError ex) {
            throw new InternalFailException(ex);
        }
        catch (AccountExist ex) {
            throw new AccountExistException("\u30a2\u30ab\u30a6\u30f3\u30c8" + account + "\u306f\u3001\u65e2\u306b\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        catch (NoPrivilege ex) {
            throw new NoPermissionException("\u7ba1\u7406\u8005\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        catch (LicenseError ex) {
            throw new LicenseException("\u73fe\u884c\u306e\u30e9\u30a4\u30bb\u30f3\u30b9\u3067\u7ba1\u7406\u3067\u304d\u308b\u30a2\u30ab\u30a6\u30f3\u30c8\u306f1\u3064\u307e\u3067\u3067\u3059\u3002 ");
        }
        this.sb.getLogger().debug((java.lang.Object)("ORBManager.createAccount(" + account + ") successful."));
    }

    private void _deleteAccount(String account) throws InternalFailException, AccountNotFoundException, NoPermissionException {
        this.sb.getLogger().debug((java.lang.Object)("Enter ORBManager.deleteAccount(" + account + ")"));
        try {
            this.service.deleteUser(account);
        }
        catch (InternalError ex) {
            throw new InternalFailException(ex);
        }
        catch (AccountNotFound ex) {
            throw new AccountNotFoundException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u3001\u30a2\u30ab\u30a6\u30f3\u30c8" + account + "\u306f\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", ex);
        }
        catch (NoPrivilege ex) {
            throw new NoPermissionException("\u7ba1\u7406\u8005\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.sb.getLogger().debug((java.lang.Object)("Enter ORBManager.deleteAccount(" + account + ") successful."));
    }

    private void _changePassword(String account, String newpassword) throws AccountNotFoundException {
        this.sb.getLogger().debug((java.lang.Object)("Enter ORBManager.changePassword(" + account + ")"));
        try {
            this.service.changePassword(account, newpassword);
        }
        catch (AccountNotFound ex) {
            throw new AccountNotFoundException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u3001\u30a2\u30ab\u30a6\u30f3\u30c8" + account + "\u306f\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", ex);
        }
        this.sb.getLogger().debug((java.lang.Object)("Enter ORBManager.changePassword(" + account + ") successful."));
    }

    private String _backup() throws InternalFailException, NoPermissionException {
        this.sb.getLogger().debug((java.lang.Object)"Enter ORBManager.backup()");
        String path = null;
        try {
            path = this.service.backup();
        }
        catch (InternalError ex) {
            throw new InternalFailException(ex);
        }
        catch (NoPrivilege e) {
            throw new NoPermissionException("\u7ba1\u7406\u8005\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.sb.getLogger().debug((java.lang.Object)"Enter ORBManager.backup() successful.");
        return path;
    }

    private void _recovery() throws InternalFailException, NoPermissionException {
        this.sb.getLogger().debug((java.lang.Object)"Enter ORBManager.recovery()");
        try {
            this.service.recovery();
        }
        catch (InternalError ex) {
            throw new InternalFailException(ex);
        }
        catch (NoPrivilege ex) {
            throw new NoPermissionException("\u7ba1\u7406\u8005\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.sb.getLogger().debug((java.lang.Object)"Enter ORBManager.recovery() successful.");
    }

    private void disconnect() {
        if (this.orb != null) {
            this.orb.shutdown(false);
            this.orb = null;
        }
    }
}

