/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate;

import com.interpress_project.modernshare.client.controller.delegate.ISVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountExistException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import java.net.MalformedURLException;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class AdminSVNManager
extends ISVNManager {
    private static AdminSVNManager instance;

    public void createAccountArea(String account) throws InternalFailException, AccountExistException {
        this.existAccount(account);
        this.createSVNSpace(account);
    }

    private ISVNDirEntry[] getAccounts() throws InternalFailException {
        SVNUrl svnurl;
        PropertyManager propmgr = PropertyManager.getInstance();
        String url = propmgr.getTargetSVNURL();
        try {
            svnurl = new SVNUrl(url);
        }
        catch (MalformedURLException ex) {
            throw new InternalFailException("\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getLocalizedMessage() + ")");
        }
        ISVNDirEntry[] entries = null;
        try {
            entries = this.svnClient.getList(svnurl, SVNRevision.HEAD, false);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30ea\u30b9\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getLocalizedMessage() + ")");
        }
        return entries;
    }

    public void existAccount(String account) throws InternalFailException, AccountExistException {
        ISVNDirEntry[] accounts = this.getAccounts();
        for (int i = 0; i < accounts.length; ++i) {
            String acct = accounts[i].getPath();
            if (!acct.equalsIgnoreCase(account)) continue;
            throw new AccountExistException("\u65e2\u306b\u30a2\u30ab\u30a6\u30f3\u30c8" + account + "\u306f\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002");
        }
    }

    public void createSVNSpace(String account) throws InternalFailException {
        SVNUrl svnurl;
        PropertyManager propmgr = PropertyManager.getInstance();
        String url = propmgr.getTargetSVNURL(account);
        try {
            svnurl = new SVNUrl(url);
        }
        catch (MalformedURLException ex) {
            throw new InternalFailException("\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getLocalizedMessage() + ")");
        }
        try {
            this.svnClient.mkdir(svnurl, "Space for " + account);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30e6\u30fc\u30b6\u9818\u57df\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getLocalizedMessage() + ")");
        }
    }

    public void deleteSVNSpace(String account) throws InternalFailException {
        SVNUrl svnurl;
        PropertyManager propmgr = PropertyManager.getInstance();
        String url = propmgr.getTargetSVNURL(account);
        try {
            svnurl = new SVNUrl(url);
        }
        catch (MalformedURLException ex) {
            throw new InternalFailException("\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getLocalizedMessage() + ")");
        }
        try {
            this.svnClient.remove(new SVNUrl[]{svnurl}, "");
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30e6\u30fc\u30b6\u9818\u57df\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getLocalizedMessage() + ")");
        }
    }

    public void deleteAccountArea(String account) throws InternalFailException, AccountNotFoundException {
        try {
            this.existAccount(account);
            throw new AccountNotFoundException();
        }
        catch (AccountExistException accountExistException) {
            this.deleteSVNSpace(account);
            return;
        }
    }

    public static AdminSVNManager getInstance() {
        if (instance == null) {
            instance = new AdminSVNManager();
        }
        return instance;
    }
}

