/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LocalViewEventSource;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.ViewEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.util.TimerTask;

public class TaskWorkerThread
extends TimerTask {
    private final SystemBase sb = SystemBase.getInstance();
    private final LocalModelManager lmmgr = LocalModelManager.getInstance();
    private final SVNCommandFactory commandFactory = SVNCommandFactory.getInstance();
    private final SVNCommandManager commandManager = SVNCommandManager.getInstance();
    private final LogEventSource logEventSource = LogEventSource.getInstance();
    private final LocalViewEventSource localViewEventSource = LocalViewEventSource.getInstance();

    @Override
    public void run() {
        this.sb.getLogger().debug((Object)"TaskThread started.");
        try {
            this.commandManager.execCommand(this.commandFactory.createUpdateClientXMLCommand());
        }
        catch (CommandException ex) {
            this.logEventSource.fireEvent(new LogEvent(this, ex.getCause().getMessage(), LogEventType.ERROR, ex));
            return;
        }
        this.localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));
        LocalRoot[] roots = this.lmmgr.getRootLineItem().getRoots();
        block8: for (int i = 0; i < roots.length; ++i) {
            switch (roots[i].getStatus()) {
                case deactive: 
                case disable: {
                    continue block8;
                }
                case active: {
                    boolean bPc2host = roots[i].getPc2host();
                    if (bPc2host && !roots[i].isDirty()) continue block8;
                    try {
                        this.commandManager.execCommand(this.commandFactory.createSyncListCommand());
                    }
                    catch (CommandException ex) {
                        this.logEventSource.fireEvent(new LogEvent(this, ex.getCause().getMessage(), LogEventType.ERROR, ex));
                        return;
                    }
                    if (bPc2host) {
                        this.commandManager.addCommand(this.commandFactory.createSyncRemoteWithLocalCommand(roots[i]));
                        continue block8;
                    }
                    this.commandManager.addCommand(this.commandFactory.createSyncLocalWithRemoteCommand(roots[i]));
                    continue block8;
                }
            }
        }
        this.commandManager.addCommand(this.commandFactory.createLocalRefreshCommand());
        this.commandManager.addCommand(this.commandFactory.createStoreClientXMLCommand());
        this.sb.getLogger().debug((Object)"TaskThread terminated.");
    }
}

