/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.TaskWorkerThread;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.util.Calendar;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

public class TaskManager {
    private final SystemBase sb = SystemBase.getInstance();
    private final PropertyManager propmgr = PropertyManager.getInstance();
    private final LogEventSource logEventSource = LogEventSource.getInstance();
    private Timer theTimer = null;
    private static TaskManager instance;

    private TaskManager() {
        this.logEventSource.addEventListener(ViewManager.getInstance());
    }

    public static TaskManager getInstance() {
        if (instance == null) {
            instance = new TaskManager();
        }
        return instance;
    }

    public void start() {
        this.sb.getLogger().debug((Object)"TaskManager started.");
    }

    public void stop() {
        if (this.theTimer != null) {
            this.theTimer.cancel();
            this.theTimer = null;
            this.sb.getLogger().debug((Object)"TaskManager stopped.");
        }
    }

    public void updateSchedule(String path) {
        if (this.theTimer != null) {
            this.theTimer.cancel();
            this.theTimer = null;
        }
        this.sb.getLogger().debug((Object)("Timer schedule for " + path));
        this.theTimer = new Timer();
        Calendar cal = Calendar.getInstance(Locale.JAPAN);
        int duration = this.propmgr.getDuration();
        cal.add(12, duration);
        this.theTimer.schedule((TimerTask)new TaskWorkerThread(), cal.getTime());
        String msg = "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306e\u540c\u671f\u304c" + cal.getTime() + "\u306b\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u3055\u308c\u307e\u3057\u305f\u3002";
        this.logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
    }

    public void dispose() {
        this.stop();
        this.logEventSource.removeEventListener(ViewManager.getInstance());
        this.sb.getLogger().debug((Object)"TaskManager disposed.");
    }
}

