/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;

public class SyncRemoteWithLocalCommand
extends ISVNCommand {
    private final SystemBase sb = SystemBase.getInstance();
    private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
    private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
    private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
    private LocalRoot localRoot = null;
    private File rootpath;

    public SyncRemoteWithLocalCommand(LocalRoot localRoot) {
        this.rootpath = new File(localRoot.getAbsolutePath());
        this.localRoot = localRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws CommandException {
        logEventSource.fireEvent(new LogEvent(this, this.rootpath + "\u306b\u683c\u7d0d\u3055\u308c\u305f\u30c7\u30fc\u30bf\u3067\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3092\u66f4\u65b0\u3057\u307e\u3059...", LogEventType.INFO));
        this.localRoot.stopFsWatcher();
        try {
            this._execute();
            this.localRoot.setDirty(false);
            this.cmdmgr.addCommand(this.factory.createRemoteRefreshCommand());
            this.cmdmgr.addCommand(this.factory.createLocalRefreshCommand());
        }
        finally {
            this.localRoot.startFsWatcher();
            this.sb.getLogger().debug((Object)this.sb.gc());
        }
        logEventSource.fireEvent(new LogEvent(this, this.rootpath + "\u3078\u306e\u66f4\u65b0\u51e6\u7406\u306f\u6210\u529f\u3057\u307e\u3057\u305f\u3002", LogEventType.INFO));
    }

    public void _execute() throws CommandException {
        this.sb.getLogger().debug((Object)"Enter SyncRemoteWithLocalCommand()._execute()");
        try {
            this.svnmgr.connect();
        }
        catch (ConnectionFailException ex) {
            throw new CommandException(ex);
        }
        try {
            this.svnmgr.cleanupFiles(this.rootpath);
        }
        catch (InternalFailException ex) {
            logEventSource.fireEvent(new LogEvent(this, "SVN\u30af\u30ea\u30fc\u30f3\u30a2\u30c3\u30d7\u51e6\u7406\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u51e6\u7406\u3092\u7d99\u7d9a\u3057\u307e\u3059\u3002: " + ex.getMessage(), LogEventType.INFO));
        }
        try {
            File[] files = this.svnmgr.prepareSyncRemoteFiles(this.rootpath);
            this.svnmgr.commitDirectory(this.rootpath, files);
        }
        catch (InternalFailException ex) {
            throw new CommandException(ex);
        }
        this.sb.getLogger().debug((Object)"Leave SyncRemoteWithLocalCommand()._execute");
    }
}

