/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.ActiveTargetCommand;
import com.interpress_project.modernshare.client.controller.command.CheckoutCommand;
import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.LocalExportCommand;
import com.interpress_project.modernshare.client.controller.command.LocalRefreshCommand;
import com.interpress_project.modernshare.client.controller.command.RemoteRefreshCommand;
import com.interpress_project.modernshare.client.controller.command.StoreClientXMLCommand;
import com.interpress_project.modernshare.client.controller.command.SyncListCommand;
import com.interpress_project.modernshare.client.controller.command.SyncLocalWithRemoteCommand;
import com.interpress_project.modernshare.client.controller.command.SyncRemoteWithLocalCommand;
import com.interpress_project.modernshare.client.controller.command.UpdateClientXMLCommand;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;

public class SVNCommandFactory {
    private static SVNCommandFactory instance;

    private SVNCommandFactory() {
    }

    public static SVNCommandFactory getInstance() {
        if (instance == null) {
            instance = new SVNCommandFactory();
        }
        return instance;
    }

    public ISVNCommand createUpdateClientXMLCommand() {
        return new UpdateClientXMLCommand();
    }

    public ISVNCommand createStoreClientXMLCommand() {
        return new StoreClientXMLCommand();
    }

    public ISVNCommand createSyncRemoteWithLocalCommand(LocalRoot localRoot) {
        return new SyncRemoteWithLocalCommand(localRoot);
    }

    public ISVNCommand createSyncLocalWithRemoteCommand(LocalRoot localRoot) {
        return new SyncLocalWithRemoteCommand(localRoot);
    }

    public ISVNCommand createSyncListCommand() {
        return new SyncListCommand();
    }

    public ISVNCommand createCheckoutCommand(String path, SVNRoot root, RootStatus status, boolean bPc2host) {
        return new CheckoutCommand(path, root, status, bPc2host);
    }

    public ISVNCommand createActiveTargetCommand(String path, RootStatus status) {
        return new ActiveTargetCommand(path, status);
    }

    public ISVNCommand createLocalExportCommand(ISVNFileItem item, String path) {
        return new LocalExportCommand(item, path);
    }

    public ISVNCommand createLocalRefreshCommand() {
        return new LocalRefreshCommand();
    }

    public ISVNCommand createRemoteRefreshCommand() {
        return new RemoteRefreshCommand();
    }
}

