/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoPermissionException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.UnknownHostException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;

public class LocalExportCommand
extends ISVNCommand {
    private final ORBManager orbmgr = ORBManager.getInstance();
    private final SystemBase sb = SystemBase.getInstance();
    private final RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
    private ISVNFileItem item = null;
    private String path = null;

    public LocalExportCommand(ISVNFileItem item, String path) {
        this.item = item;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws CommandException {
        try {
            this._execute();
        }
        finally {
            this.sb.getLogger().debug((Object)this.sb.gc());
        }
    }

    private void _execute() throws CommandException {
        try {
            this.orbmgr.updateSVNServerInfo();
        }
        catch (ConnectionFailException ex) {
            throw new CommandException(ex);
        }
        catch (NoPermissionException ex) {
            throw new CommandException(ex);
        }
        catch (UnknownHostException ex) {
            throw new CommandException(ex);
        }
        try {
            this.svnmgr.connect();
        }
        catch (ConnectionFailException ex) {
            throw new CommandException(ex);
        }
        try {
            this.svnmgr.exportItem(this.item, new File(this.path));
        }
        catch (InternalFailException ex) {
            throw new CommandException(ex);
        }
    }
}

