/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.SVNFolderUtil;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.DeleteFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.TagExistException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class UnRegisterTargetAction
extends ActionAdaptor {
    private final ViewManager vmgr;
    private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
    private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
    private String path;
    private String tagName;

    public UnRegisterTargetAction(ViewManager vmgr, String path, String tagName) {
        this.setText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306e\u767b\u9332\u89e3\u9664\u3068\u30ea\u30dd\u30b8\u30c8\u30ea\u30c7\u30fc\u30bf\u306e\u524a\u9664(&X)");
        this.setToolTipText("\u30ed\u30fc\u30ab\u30eb\u30d5\u30a9\u30eb\u30c0\u306e\u76e3\u8996\u3092\u89e3\u9664\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("delete"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
        this.path = path;
        this.tagName = tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskManager taskmgr = TaskManager.getInstance();
        try {
            taskmgr.stop();
            this.logEventSource.fireEvent(new LogEvent((Object)this, LogEventType.CLEAR));
            boolean bRes = this.vmgr.getDialogManager().createYesNoMessageDialog(this.path + "\u306e\u767b\u9332\u89e3\u9664", "\u30ed\u30fc\u30ab\u30eb\u30d5\u30a9\u30eb\u30c0" + this.path + "\u306e\u76e3\u8996\u767b\u9332\u3092\u89e3\u9664\u3057\u307e\u3059\u3002(\u30ed\u30fc\u30ab\u30eb\u30d5\u30a9\u30eb\u30c0\u306f\u524a\u9664\u3055\u308c\u307e\u305b\u3093\u3002)");
            if (!bRes) {
                return;
            }
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.vmgr.getShell());
            UnRegisterCommand op = new UnRegisterCommand();
            dlg.run(true, false, (IRunnableWithProgress)op);
        }
        catch (Exception ex) {
            this.sb.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
        }
        finally {
            taskmgr.start();
        }
        this.guiEventSource.fireEvent(new GUIEvent((Object)this, "\u30ed\u30fc\u30ab\u30eb\u30d5\u30a9\u30eb\u30c0" + this.path + "\u306e\u76e3\u8996\u767b\u9332\u3092\u89e3\u9664\u3057\u307e\u3057\u305f\u3002", GUIEventType.FINISH));
    }

    private class UnRegisterCommand
    implements IRunnableWithProgress {
        private UnRegisterCommand() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            LocalSVNManager svnmgr = LocalSVNManager.getInstance();
            String msg = null;
            boolean bRemote = false;
            monitor.beginTask("\u30ed\u30fc\u30ab\u30eb\u30d5\u30a9\u30eb\u30c0\u306e\u76e3\u8996\u767b\u9332\u306e\u89e3\u9664", 8);
            File file = new File(UnRegisterTargetAction.this.path);
            if (!file.exists()) {
                monitor.subTask("\u30ed\u30fc\u30ab\u30eb\u30d5\u30a9\u30eb\u30c0" + UnRegisterTargetAction.this.path + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            }
            monitor.worked(1);
            msg = "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u63a5\u7d9a\u3092\u3057\u3066\u3044\u307e\u3059...";
            monitor.subTask(msg);
            UnRegisterTargetAction.this.logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
            try {
                svnmgr.connect();
            }
            catch (ConnectionFailException ex) {
                throw new InvocationTargetException(ex, ex.getCause().getMessage());
            }
            monitor.worked(1);
            msg = "\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u78ba\u8a8d\u3057\u3066\u3044\u307e\u3059...";
            monitor.subTask(msg);
            try {
                svnmgr.existAccount();
            }
            catch (AccountNotFoundException ex) {
                throw new InvocationTargetException(ex, ex.getCause().getMessage());
            }
            monitor.worked(1);
            try {
                msg = "\u30bf\u30b0\u540d\u3092\u78ba\u8a8d\u3057\u3066\u3044\u307e\u3059...";
                monitor.subTask(msg);
                UnRegisterTargetAction.this.logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
                svnmgr.existTagName(UnRegisterTargetAction.this.tagName);
                monitor.worked(1);
            }
            catch (TagExistException ex) {
                bRemote = true;
            }
            catch (Exception ex) {
                throw new InvocationTargetException(ex, ex.getMessage());
            }
            if (bRemote) {
                try {
                    msg = "\u30ea\u30e2\u30fc\u30c8\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059...";
                    monitor.subTask(msg);
                    UnRegisterTargetAction.this.logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
                    svnmgr.deleteRemoteFolder(UnRegisterTargetAction.this.tagName);
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex, ex.getMessage());
                }
            }
            monitor.worked(1);
            msg = "\u30ed\u30fc\u30ab\u30eb\u30d5\u30a9\u30eb\u30c0\u304b\u3089\u7ba1\u7406\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059...";
            monitor.subTask(msg);
            UnRegisterTargetAction.this.logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
            SVNFolderUtil futil = SVNFolderUtil.getInstance();
            ArrayList<File> list = futil.getSVNDirListInTarget(new File(UnRegisterTargetAction.this.path));
            try {
                futil.deleteFiles(list);
            }
            catch (DeleteFailException ex) {
                throw new InvocationTargetException(ex, ex.getMessage());
            }
            monitor.worked(1);
            msg = "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3057\u3066\u3044\u307e\u3059...";
            monitor.subTask(msg);
            UnRegisterTargetAction.this.logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
            LocalModelManager mgr = LocalModelManager.getInstance();
            mgr.removeRoot(UnRegisterTargetAction.this.path);
            monitor.worked(1);
            monitor.subTask("\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3092\u3057\u3066\u3044\u307e\u3059...");
            UnRegisterTargetAction.this.cmdmgr.addCommand(UnRegisterTargetAction.this.factory.createRemoteRefreshCommand());
            monitor.worked(1);
            monitor.done();
        }
    }
}

