/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class SyncDataAction
extends ActionAdaptor {
    private final SystemBase sb = SystemBase.getInstance();
    private final ViewManager vmgr;
    private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
    private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
    private LocalRoot localRoot = null;

    public SyncDataAction(ViewManager vmgr, LocalRoot localRoot) {
        this.setText("\u30c7\u30fc\u30bf\u306e\u5f37\u5236\u540c\u671f(&C)");
        this.setToolTipText("HotShot\u30d5\u30a9\u30eb\u30c0\u3068\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u9593\u3067\u5f37\u5236\u540c\u671f\u3092\u884c\u3044\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("sync"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
        this.localRoot = localRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        TaskManager taskmgr = TaskManager.getInstance();
        int mode = -1;
        try {
            taskmgr.stop();
            boolean bResult = this.vmgr.getDialogManager().createYesNoMessageDialog("\u30c7\u30fc\u30bf\u306e\u540c\u671f\u78ba\u8a8d", "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + this.localRoot.getAbsolutePath() + "\u306b\u5bfe\u3059\u308b\u540c\u671f\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002");
            if (!bResult) {
                return;
            }
            if (this.localRoot.getPc2host()) {
                mode = this.vmgr.getDialogManager().createSyncModeDialog();
                if (mode == -1) {
                    return;
                }
            } else {
                mode = 1;
            }
            this.cmdmgr.execCommand(this.factory.createSyncListCommand());
            switch (mode) {
                default: {
                    return;
                }
                case 0: {
                    this.sb.getLogger().debug((Object)"PC->Remote: \u30ed\u30fc\u30ab\u30eb\u3067\u30ea\u30e2\u30fc\u30c8\u3092\u66f4\u65b0");
                    this.cmdmgr.execCommand(this.factory.createSyncRemoteWithLocalCommand(this.localRoot));
                    return;
                }
                case 1: {
                    this.sb.getLogger().debug((Object)"Remote->PC: \u30ea\u30e2\u30fc\u30c8\u3067\u30ed\u30fc\u30ab\u30eb\u3092\u66f4\u65b0");
                    this.cmdmgr.execCommand(this.factory.createSyncLocalWithRemoteCommand(this.localRoot));
                    return;
                }
            }
        }
        catch (CommandException ex) {
            String msg = ex.getCause().getMessage();
            this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.ERROR, ex));
            this.vmgr.getDialogManager().createErrorMessageDialog(msg);
            return;
        }
        finally {
            taskmgr.start();
        }
    }
}

