/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.SVNFolderUtil;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.DeleteFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.ViewEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;
import java.util.ArrayList;

public final class DisableTargetAction
extends ActionAdaptor {
    private SystemBase sb = SystemBase.getInstance();
    private ViewManager vmgr;
    private String path;

    public DisableTargetAction(ViewManager vmgr, String path) {
        this.setText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306e\u767b\u9332\u89e3\u9664(&U)");
        this.setToolTipText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306e\u767b\u9332\u3092\u89e3\u9664\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("unconnected"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.sb.getLogger().debug((Object)"Enter DisableTargetAction()");
        TaskManager taskmgr = TaskManager.getInstance();
        try {
            taskmgr.stop();
            boolean bAnswer = this.vmgr.getDialogManager().createYesNoMessageDialog("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306e\u767b\u9332\u89e3\u9664", "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + this.path + "\u306e\u767b\u9332\u3092\u89e3\u9664\u3057\u307e\u3059\u3002(\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u5074\u306e\u30c7\u30fc\u30bf\u306f\u524a\u9664\u3055\u308c\u307e\u305b\u3093\u3002)");
            if (!bAnswer) {
                return;
            }
            SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
            SVNCommandFactory factory = SVNCommandFactory.getInstance();
            ISVNCommand command = factory.createActiveTargetCommand(this.path, RootStatus.deactive);
            try {
                cmdmgr.execCommand(command);
            }
            catch (CommandException e) {
                // empty catch block
            }
            this.logEventSource.fireEvent(new LogEvent((Object)this, "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + this.path + "\u304b\u3089\u7ba1\u7406\u60c5\u5831\u3092\u524a\u9664\u3057\u307e\u3059\u3002\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...", LogEventType.INFO));
            if (new File(this.path).exists()) {
                SVNFolderUtil futil = SVNFolderUtil.getInstance();
                ArrayList<File> list = futil.getSVNDirListInTarget(new File(this.path));
                try {
                    futil.deleteFiles(list);
                }
                catch (DeleteFailException ex) {
                    this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                    taskmgr.start();
                    return;
                }
            }
            LocalModelManager lmmgr = LocalModelManager.getInstance();
            lmmgr.removeRoot(this.path);
            this.localViewEventSource.fireEvent(new LocalViewEvent((Object)this, ViewEventType.REFRESH));
            this.logEventSource.fireEvent(new LogEvent((Object)this, "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + this.path + "\u304b\u3089\u7ba1\u7406\u60c5\u5831\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002", LogEventType.INFO));
        }
        finally {
            taskmgr.start();
        }
    }
}

