/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.client.IUserAdmin;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

public class Userdel
extends IUserAdmin {
    public Userdel(String[] args) {
        super(args);
        this.sb.setLoggerInfo("HotShot_Client", "etc/log4j.properties");
    }

    @Override
    protected void parseOptions(String[] args) {
        if (args.length == 0) {
            this.usage();
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-rootpass".equalsIgnoreCase(args[i])) {
                this.setRootPassword(args[++i]);
                continue;
            }
            if ("-user".equalsIgnoreCase(args[i])) {
                this.setNewAccount(args[++i]);
                continue;
            }
            if ("-host".equalsIgnoreCase(args[i])) {
                this.setAdminHost(args[++i]);
                continue;
            }
            if (!"-port".equalsIgnoreCase(args[i])) continue;
            this.setAdminPort(new Integer(args[++i]));
        }
        if (this.getRootPassword().length() == 0 || this.getNewAccount().length() == 0) {
            this.usage();
            System.exit(-1);
        }
    }

    private void usage() {
        System.out.println("Usage: Userdel -rootpass <password> -user <account> -host <targethost> -port <portnum>");
        System.out.println("HotShot utility userdel deletes a user account from the system and makes the appropriate account-related changes to the system file and file system.");
        System.out.println("\t-rootpass <pass>\t: Password for root account.");
        System.out.println("\t-user <account>\t\t: The login ID to be deleted.");
        System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
        System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
    }

    @Override
    protected void run() {
        try {
            this.orbmgr.deleteAccount("root", this.getRootPassword(), this.getNewAccount());
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            this.sb.getLogger().error((Object)msg);
            return;
        }
        try {
            this.svnmgr.connect("root", this.getRootPassword());
        }
        catch (ConnectionFailException ex) {
            String msg = ex.getMessage();
            this.sb.getLogger().error((Object)msg);
            return;
        }
        try {
            this.svnmgr.deleteAccountArea(this.getNewAccount());
        }
        catch (InternalFailException ex) {
            String msg = ex.getMessage();
            this.sb.getLogger().error((Object)msg);
            return;
        }
        catch (AccountNotFoundException ex) {
            this.sb.getLogger().warn((Object)("\u30a2\u30ab\u30a6\u30f3\u30c8" + this.getNewAccount() + "\u306e\u9818\u57df\u306f\u5b58\u5728\u3057\u3066\u3044\u307e\u305b\u3093\u3002"));
        }
        this.sb.getLogger().info((Object)("\u30a2\u30ab\u30a6\u30f3\u30c8" + this.getNewAccount() + "\u306e\u524a\u9664\u304c\u6210\u529f\u3057\u307e\u3057\u305f\u3002"));
    }

    public static void main(String[] args) {
        Userdel admin = new Userdel(args);
        admin.exec();
    }
}

