/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client;

import com.interpress_project.modernshare.client.IUserAdmin;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountExistException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

public class Useradd
extends IUserAdmin {
    public Useradd(String[] args) {
        super(args);
        this.sb.setLoggerInfo("HotShot_Client", "etc/log4j.properties");
    }

    @Override
    protected void parseOptions(String[] args) {
        if (args.length == 0) {
            this.usage();
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("-rootpass".equalsIgnoreCase(args[i])) {
                this.setRootPassword(args[++i]);
                continue;
            }
            if ("-user".equalsIgnoreCase(args[i])) {
                this.setNewAccount(args[++i]);
                continue;
            }
            if ("-pass".equalsIgnoreCase(args[i])) {
                this.setNewPassword(args[++i]);
                continue;
            }
            if ("-host".equalsIgnoreCase(args[i])) {
                this.setAdminHost(args[++i]);
                continue;
            }
            if (!"-port".equalsIgnoreCase(args[i])) continue;
            this.setAdminPort(new Integer(args[++i]));
        }
        if (this.getRootPassword().length() == 0 || this.getNewAccount().length() == 0 || this.getNewPassword().length() == 0) {
            this.usage();
            System.exit(-1);
        }
    }

    private void usage() {
        System.out.println("Usage: useradd -rootpass <password> -user <new account> -pass <new password> -host <targethost> -port <portnum>");
        System.out.println("HotShot utility useradd administer a new user login on the HotShot system.");
        System.out.println("\t-rootpass <pass>\t: Password for root account.");
        System.out.println("\t-user <account>\t\t: New login ID to be added.");
        System.out.println("\t-pass <newpass>\t: The password for the login ID.");
        System.out.println("\t-host <hostname>\t: The hostname of HotShot datacenter.");
        System.out.println("\t-port <number>\t\t: Port number of HotShot datacenter.");
    }

    @Override
    protected void run() {
        try {
            this.orbmgr.createAccount("root", this.getRootPassword(), this.getNewAccount(), this.getNewPassword());
        }
        catch (Exception ex) {
            this.sb.getLogger().error((Object)("\u65b0\u898f\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002: " + ex.getMessage()));
            return;
        }
        try {
            this.svnmgr.connect(this.getNewAccount(), this.getNewPassword());
        }
        catch (ConnectionFailException ex) {
            this.sb.getLogger().error((Object)("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002: " + ex.getMessage()));
            return;
        }
        try {
            this.svnmgr.createAccountArea(this.getNewAccount());
        }
        catch (InternalFailException ex) {
            this.sb.getLogger().error((Object)("\u65b0\u898f\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u9818\u57df\u78ba\u4fdd\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002: " + ex.getMessage()));
            return;
        }
        catch (AccountExistException ex) {
            this.sb.getLogger().fatal((Object)("\u65e2\u306b\u30a2\u30ab\u30a6\u30f3\u30c8" + this.getNewAccount() + "\u306e\u305f\u3081\u306e\u9818\u57df\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002"));
            this.sb.getLogger().fatal((Object)("\u4e00\u65e6\u30a2\u30ab\u30a6\u30f3\u30c8" + this.getNewAccount() + "\u3092\u524a\u9664\u3057\u3001\u518d\u5ea6\u767b\u9332\u3055\u308c\u308b\u3053\u3068\u3092\u304a\u5968\u3081\u3057\u307e\u3059\u3002"));
            return;
        }
        this.sb.getLogger().info((Object)("\u65b0\u898f\u30a2\u30ab\u30a6\u30f3\u30c8" + this.getNewAccount() + "\u306e\u767b\u9332\u304c\u6210\u529f\u3057\u307e\u3057\u305f\u3002"));
    }

    public static void main(String[] args) {
        Useradd admin = new Useradd(args);
        admin.exec();
    }
}

