/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi.bitmap;

import com.jniwrapper.ArrayParameter;
import com.jniwrapper.Parameter;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

class BitmapBuilderIndexColorModel
extends BitmapBuilder {
    private static final String INVALID_COLOR_MODEL_MSG = "This builder works with IndexColorModel only. CurrentModel = ";

    public BitmapBuilderIndexColorModel(int bitCount, BufferedImage bufferedImage) {
        super(bitCount, bufferedImage);
        this.checkColorModel();
    }

    @Override
    public int getColorTableSize() {
        return this.getIndexColorModel().getMapSize();
    }

    @Override
    public void buildColorTable(ArrayParameter quadArray) {
        int paletteSize = this.getColorTableSize();
        byte[] reds = new byte[paletteSize];
        byte[] greens = new byte[paletteSize];
        byte[] blues = new byte[paletteSize];
        IndexColorModel indexColorModel = this.getIndexColorModel();
        indexColorModel.getReds(reds);
        indexColorModel.getGreens(greens);
        indexColorModel.getBlues(blues);
        for (int i = 0; i < paletteSize; ++i) {
            RGBQuad quad = new RGBQuad();
            quad.setRed(this.getColorComponent(reds[i]));
            quad.setGreen(this.getColorComponent(greens[i]));
            quad.setBlue(this.getColorComponent(blues[i]));
            quadArray.setElement(i, (Parameter)quad);
        }
    }

    private long getColorComponent(byte color) {
        return color >= 0 ? (long)color : (long)(color + 256);
    }

    @Override
    public void setBitmapColors() {
        byte[] pixelIndexes = this.getPixelIndexes();
        int pixelsPerBit = 8 / this.getBitCount();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); x += pixelsPerBit) {
                byte bitmapByte = 0;
                for (int i = 0; i < pixelsPerBit && x + i < this.getWidth(); ++i) {
                    byte paletteIndex = pixelIndexes[this.getImageOffset(x + i, y)];
                    bitmapByte = this.addPixelValueToBitmapByte(bitmapByte, paletteIndex, (pixelsPerBit - i - 1) * this.getBitCount());
                }
                this.setBitmapByte(this.getOffsetInBitmapBytes(x, y), bitmapByte);
            }
        }
    }

    public byte addPixelValueToBitmapByte(byte bitmapByte, byte value, int bitOffset) {
        return (byte)(bitmapByte | value << bitOffset);
    }

    private byte[] getPixelIndexes() {
        byte[] indexes = new byte[this.getWidth() * this.getHeight()];
        this.getBufferedImage().getRaster().getDataElements(0, 0, this.getWidth(), this.getHeight(), indexes);
        return indexes;
    }

    @Override
    public Image getTransparentMask() {
        if (this.getIndexColorModel().getTransparentPixel() != -1) {
            IndexColorModel blackWhiteModel = new IndexColorModel(1, 2, this.createBlackWhitePalette(), this.createBlackWhitePalette(), this.createBlackWhitePalette());
            WritableRaster raster = this.createRasterWithMask();
            BufferedImage result = new BufferedImage(blackWhiteModel, raster, false, new Hashtable());
            return result;
        }
        return null;
    }

    private WritableRaster createRasterWithMask() {
        int transparentPixel = this.getIndexColorModel().getTransparentPixel();
        WritableRaster raster = this.getIndexColorModel().createCompatibleWritableRaster(this.getWidth(), this.getHeight());
        byte[] pixelIndexes = this.getPixelIndexes();
        byte[] blackWhiteIndexes = new byte[this.getWidth() * this.getHeight()];
        for (int i = 0; i < pixelIndexes.length; ++i) {
            byte color;
            int pixelIndex = pixelIndexes[i] >= 0 ? pixelIndexes[i] : pixelIndexes[i] + 256;
            blackWhiteIndexes[i] = color = pixelIndex == transparentPixel ? (byte)0 : 1;
        }
        raster.setDataElements(0, 0, this.getWidth(), this.getHeight(), blackWhiteIndexes);
        return raster;
    }

    private byte[] createBlackWhitePalette() {
        return new byte[]{0, -1};
    }

    protected IndexColorModel getIndexColorModel() {
        return (IndexColorModel)this.getColorModel();
    }

    private void checkColorModel() {
        if (!(this.getColorModel() instanceof IndexColorModel)) {
            throw new RuntimeException(INVALID_COLOR_MODEL_MSG + this.getColorModel());
        }
    }
}

