/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi.bitmap;

import com.jniwrapper.win32.gdi.bitmap.ARGB;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderDirectColorModel;
import java.awt.image.BufferedImage;

class Bitmap32BitBuilder
extends BitmapBuilderDirectColorModel {
    public Bitmap32BitBuilder(BufferedImage bufferedImage) {
        super(32, bufferedImage);
    }

    @Override
    public void setPixel(ARGB argb, int offset) {
        byte r = (byte)argb.getRed();
        byte g = (byte)argb.getGreen();
        byte b = (byte)argb.getBlue();
        byte a = (byte)argb.getAlpha();
        if (a != -1) {
            r = this.getTransparentColor(r, a);
            g = this.getTransparentColor(g, a);
            b = this.getTransparentColor(b, a);
        }
        this.setBitmapByte(offset + 3, a);
        this.setBitmapByte(offset + 2, r);
        this.setBitmapByte(offset + 1, g);
        this.setBitmapByte(offset, b);
    }

    private byte getTransparentColor(byte c, byte a) {
        if (a == -1) {
            return (byte)c;
        }
        int color = c >= 0 ? c : c + 256;
        int alpha = a >= 0 ? a : a + 256;
        int result = color * alpha / 255;
        return (byte)result;
    }
}

