/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.wizard;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.SVNFolderUtil;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.DeleteFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.client.view.wizard.NoticeFile;
import com.interpress_project.modernshare.client.view.wizard.RegConfirmPage;
import com.interpress_project.modernshare.client.view.wizard.RegWelcomePage;
import com.interpress_project.modernshare.client.view.wizard.RegWizardPage1;
import com.interpress_project.modernshare.client.view.wizard.RegWizardPage2;
import com.interpress_project.modernshare.client.view.wizard.RegWizardPage3;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class RegisterTargetFolderWizard
extends Wizard {
    private final SystemBase sb = SystemBase.getInstance();
    private final ViewManager vmgr = ViewManager.getInstance();
    private final LogEventSource logEventSource = LogEventSource.getInstance();
    private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
    private final ORBManager orbmgr = ORBManager.getInstance();
    private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
    private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
    private final RegWelcomePage regWelcomePage = new RegWelcomePage();
    private final RegWizardPage1 regWizardPage1 = new RegWizardPage1();
    private final RegWizardPage2 regWizardPage2;
    private final RegWizardPage3 regWizardPage3 = new RegWizardPage3();
    private final RegConfirmPage regConfirmPage = new RegConfirmPage();

    public RegisterTargetFolderWizard(ArrayList<SVNRoot> list) {
        this.addPage((IWizardPage)this.regWelcomePage);
        this.addPage((IWizardPage)this.regWizardPage1);
        this.regWizardPage2 = new RegWizardPage2(list);
        this.addPage((IWizardPage)this.regWizardPage2);
        this.addPage((IWizardPage)this.regWizardPage3);
        this.addPage((IWizardPage)this.regConfirmPage);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0 - \u767b\u9332\u30a6\u30a3\u30b6\u30fc\u30c9");
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                RegisterTargetFolderWizard.this.registerTargetFolder(monitor);
            }
        };
        try {
            this.logEventSource.fireEvent(new LogEvent((Object)this, LogEventType.CLEAR));
            this.getContainer().run(true, true, op);
        }
        catch (Exception ex) {
            this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
            this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
            return false;
        }
        return true;
    }

    private void registerTargetFolder(IProgressMonitor monitor) throws InvocationTargetException {
        File path = new File(this.regWizardPage1.getPath());
        String tagName = this.regWizardPage2.getTagName();
        RootStatus rootStatus = this.regWizardPage3.getStatus();
        boolean bPc2host = this.regWizardPage3.getPc2host();
        File[] files = null;
        String msg = null;
        PropertyManager propmgr = PropertyManager.getInstance();
        monitor.beginTask("", 9);
        msg = "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u304b\u3089\u30a2\u30af\u30bb\u30b9\u60c5\u5831\u3092\u53d6\u5f97\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        try {
            this.orbmgr.updateSVNServerInfo();
        }
        catch (Exception ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        finally {
            monitor.worked(1);
        }
        msg = "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u3068\u3057\u3066\u767b\u9332\u3059\u308b\u30d5\u30a9\u30eb\u30c0\u306e\u5185\u5bb9\u3092\u30c1\u30a7\u30c3\u30af\u3057\u307e\u3059\u3002\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        SVNFolderUtil futil = SVNFolderUtil.getInstance();
        ArrayList<File> svnlist = futil.getSVNDirListInTarget(path);
        if (svnlist.size() > 0) {
            boolean bAnswer = this.vmgr.getDialogManager().createYesNoMessageDialog("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u306e\u78ba\u8a8d", "\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a9\u30eb\u30c0" + path + "\u306f\u65e2\u306bHotShot\u3067\u7ba1\u7406\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4e00\u65e6HotShot\u3067\u306e\u7ba1\u7406\u3092\u89e3\u9664\u3057\u307e\u3059\u304b?");
            if (bAnswer) {
                msg = "\u767b\u9332\u3059\u308b\u30d5\u30a9\u30eb\u30c0\u304b\u3089.svn\u30d5\u30a9\u30eb\u30c0\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059...";
                monitor.subTask(msg);
                this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
                try {
                    futil.deleteFiles(svnlist);
                }
                catch (DeleteFailException ex) {
                    throw new InvocationTargetException(ex, ex.getMessage());
                }
            } else {
                throw new InvocationTargetException(null, "HotShot\u3067\u7ba1\u7406\u3055\u308c\u305f\u30d5\u30a9\u30eb\u30c0\u3092\u767b\u9332\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        }
        monitor.worked(1);
        SystemBase.getInstance().gc();
        msg = "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u63a5\u7d9a\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        try {
            this.svnmgr.connect();
        }
        catch (ConnectionFailException ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        monitor.worked(1);
        msg = "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0" + path + "\u3092\u521d\u671f\u5316\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        try {
            this.checkout(path, tagName);
        }
        catch (InternalFailException ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        monitor.worked(1);
        msg = "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u306b\u3042\u308b\u30c7\u30fc\u30bf\u3092\u767b\u9332\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        try {
            files = this.registerLocalFiles(path);
        }
        catch (InternalFailException ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        monitor.worked(1);
        msg = "\u30c7\u30fc\u30bf\u3092\u9001\u4fe1\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        try {
            this.commit(path, files);
        }
        catch (InternalFailException ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        monitor.worked(1);
        msg = "Readme\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        if (bPc2host) {
            new NoticeFile(path.getAbsolutePath(), propmgr.getIgnoreFilterList(), false).create();
        } else {
            new NoticeFile(path.getAbsolutePath(), propmgr.getIgnoreFilterList(), true).create();
        }
        monitor.worked(1);
        msg = "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        LocalModelManager limgr = LocalModelManager.getInstance();
        limgr.addRoot(path.getAbsolutePath(), tagName, rootStatus, bPc2host);
        monitor.worked(1);
        this.sb.gc();
        monitor.subTask("\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3092\u3057\u3066\u3044\u307e\u3059...");
        this.cmdmgr.addCommand(this.factory.createRemoteRefreshCommand());
        monitor.worked(1);
        monitor.done();
    }

    private void checkout(File rootpath, String tagName) throws InternalFailException {
        this.svnmgr.initialCheckoutFolder(rootpath, tagName);
    }

    private File[] registerLocalFiles(File rootpath) throws InternalFailException {
        return this.svnmgr.initialRegisterFiles(rootpath);
    }

    private void commit(File rootpath, File[] pathes) throws InternalFailException {
        this.svnmgr.commitDirectory(rootpath, pathes);
    }
}

