/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.wizard;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.client.view.wizard.CheckoutConfirmPage;
import com.interpress_project.modernshare.client.view.wizard.CheckoutWelcomePage;
import com.interpress_project.modernshare.client.view.wizard.CheckoutWizardPage1;
import com.interpress_project.modernshare.client.view.wizard.CheckoutWizardPage2;
import com.interpress_project.modernshare.client.view.wizard.CheckoutWizardPage3;
import com.interpress_project.modernshare.client.view.wizard.NoticeFile;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class CheckoutWizard
extends Wizard {
    private final ViewManager vmgr = ViewManager.getInstance();
    private final LogEventSource logEventSource = LogEventSource.getInstance();
    private CheckoutWelcomePage checkoutWelcomePage = new CheckoutWelcomePage();
    private CheckoutWizardPage1 checkoutWizardPage1 = null;
    private CheckoutWizardPage2 checkoutWizardPage2 = new CheckoutWizardPage2();
    private CheckoutWizardPage3 checkoutWizardPage3 = new CheckoutWizardPage3();
    private CheckoutConfirmPage checkoutConfirmPage = new CheckoutConfirmPage();

    public CheckoutWizard(ArrayList<SVNRoot> list) {
        this.addPage((IWizardPage)this.checkoutWelcomePage);
        this.checkoutWizardPage1 = new CheckoutWizardPage1(list);
        this.addPage((IWizardPage)this.checkoutWizardPage1);
        this.addPage((IWizardPage)this.checkoutWizardPage2);
        this.addPage((IWizardPage)this.checkoutWizardPage3);
        this.addPage((IWizardPage)this.checkoutConfirmPage);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0 - \u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u30fb\u30a6\u30a3\u30b6\u30fc\u30c9");
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                CheckoutWizard.this.checkout(monitor);
            }
        };
        try {
            this.logEventSource.fireEvent(new LogEvent((Object)this, LogEventType.CLEAR));
            this.getContainer().run(true, true, op);
        }
        catch (InvocationTargetException ex) {
            this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getLocalizedMessage(), LogEventType.ERROR, ex));
            this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void checkout(IProgressMonitor monitor) throws InvocationTargetException {
        SVNRoot root = this.checkoutWizardPage1.getSVNRoot();
        String path = this.checkoutWizardPage2.getPath();
        RootStatus status = this.checkoutWizardPage3.getStatus();
        boolean bPc2host = this.checkoutWizardPage3.getPc2host();
        String msg = null;
        PropertyManager propmgr = PropertyManager.getInstance();
        monitor.beginTask("", 5);
        msg = "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u3068\u3057\u3066\u4f5c\u6210\u3059\u308b\u30d5\u30a9\u30eb\u30c0\u306e\u5185\u5bb9\u3092\u30c1\u30a7\u30c3\u30af\u3057\u307e\u3059\u3002\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        File targetfile = new File(path);
        String[] list = targetfile.list();
        if (list == null) {
            this.vmgr.getDialogManager().createErrorMessageDialog(path + "\u306b\u30a2\u30af\u30bb\u30b9\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        if (list.length > 0) {
            boolean bAnswer = this.vmgr.getDialogManager().createYesNoMessageDialog("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u306e\u78ba\u8a8d", "\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a9\u30eb\u30c0" + path + "\u306b\u306f\u65e2\u306b\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002\u5168\u3066\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b?");
            if (bAnswer) {
                msg = "\u30d5\u30a9\u30eb\u30c0\u304b\u3089\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059...";
                monitor.subTask(msg);
                this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
                try {
                    FileUtils.cleanDirectory((File)targetfile);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex, ex.getMessage());
                }
            } else {
                msg = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3059\u308b\u30d5\u30a9\u30eb\u30c0\u3092\u3001\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u3068\u3057\u3066\u4f5c\u6210\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002";
                this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.ERROR));
                this.vmgr.getDialogManager().createInformationMessageDialog("\u30d5\u30a9\u30eb\u30c0\u306e\u78ba\u8a8d", msg);
                return;
            }
        }
        monitor.worked(1);
        SystemBase.getInstance().gc();
        msg = "\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u3092\u884c\u3063\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        SVNCommandFactory factory = SVNCommandFactory.getInstance();
        ISVNCommand command = factory.createCheckoutCommand(path, root, status, bPc2host);
        SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
        try {
            cmdmgr.execCommand(command);
            monitor.worked(1);
        }
        catch (CommandException ex) {
            throw new InvocationTargetException(ex, ex.getMessage());
        }
        msg = "Readme\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        if (bPc2host) {
            new NoticeFile(path, propmgr.getIgnoreFilterList(), false).create();
        } else {
            new NoticeFile(path, propmgr.getIgnoreFilterList(), true).create();
        }
        monitor.worked(1);
        msg = "\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u4fdd\u5b58\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        LocalModelManager limgr = LocalModelManager.getInstance();
        limgr.addRoot(path, root.getName(), status, bPc2host);
        monitor.worked(1);
        msg = "\u30ed\u30fc\u30ab\u30ebPC\u3092\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3057\u3066\u3044\u307e\u3059...";
        monitor.subTask(msg);
        this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.INFO));
        cmdmgr.addCommand(factory.createLocalRefreshCommand());
        monitor.worked(1);
        monitor.done();
    }
}

