/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.remotefs;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RemoteFileTreeContentProvider
implements ITreeContentProvider {
    protected ViewManager vmgr = ViewManager.getInstance();
    protected LogEventSource logEventSource = LogEventSource.getInstance();

    public Object[] getChildren(Object element) {
        GetSVNItemsWorker worker = new GetSVNItemsWorker((ISVNFileItem)element);
        this.vmgr.getShell().getDisplay().syncExec((Runnable)worker);
        return worker.getKids();
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
    }

    private class GetSVNItemsWorker
    implements Runnable {
        private ISVNFileItem fileItem;
        private Object[] kids = null;

        public GetSVNItemsWorker(ISVNFileItem fileItem) {
            this.fileItem = fileItem;
        }

        @Override
        public void run() {
            try {
                this.kids = this.fileItem.getSVNItems();
            }
            catch (InternalFailException ex) {
                RemoteFileTreeContentProvider.this.logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
            }
        }

        public Object[] getKids() {
            return this.kids == null ? new Object[]{} : this.kids;
        }
    }
}

