/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.remotefs;

import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class RemoteFileTableLabelProvider
implements ITableLabelProvider {
    private final SystemBase sb = SystemBase.getInstance();

    public String getColumnText(Object element, int column_index) {
        switch (column_index) {
            default: {
                this.sb.getLogger().fatal((Object)("RemoteTable\u63cf\u753b\u6642\u306b\u4e0d\u660e\u306a\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u756a\u53f7\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002" + column_index));
                return "";
            }
            case 0: {
                String s = ((ISVNFileItem)element).getName();
                try {
                    s = URLDecoder.decode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    this.sb.getLogger().error((Object)"UnsupportedEncodingException decording string: ", (Throwable)ex);
                }
                return s;
            }
            case 1: {
                String s = String.valueOf(((ISVNFileItem)element).getRevision());
                return s;
            }
            case 2: {
                String s = String.valueOf(((ISVNFileItem)element).getLastChangedRevision());
                return s;
            }
            case 3: {
                return ((ISVNFileItem)element).getLastCommitAuthor();
            }
            case 4: {
                return ((ISVNFileItem)element).getLastChangedDate().toString();
            }
            case 5: {
                String url = ((ISVNFileItem)element).getURL();
                URI u = null;
                try {
                    u = new URI(url);
                }
                catch (URISyntaxException ex) {
                    this.sb.getLogger().fatal((Object)("RemoteTable\u63cf\u753b\u6642\u306bURI\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(7)" + url));
                    return "";
                }
                return u.getPath();
            }
            case 6: 
        }
        return ((ISVNFileItem)element).getUUID();
    }

    public void addListener(ILabelProviderListener ilabelproviderlistener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object obj, String s) {
        return false;
    }

    public void removeListener(ILabelProviderListener ilabelproviderlistener) {
    }

    public Image getColumnImage(Object element, int column_index) {
        if (column_index != 0) {
            return null;
        }
        if (((ISVNFileItem)element).isDirectory()) {
            return ImageFactory.getInstance().getImage("rfolder");
        }
        String fileName = ((ISVNFileItem)element).getURL();
        return ImageFactory.getInstance().getAssociatedImageToFile(fileName);
    }
}

