/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.remotefs;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventSource;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RemoteFileTableContentProvider
implements IStructuredContentProvider {
    protected ViewManager vmgr = ViewManager.getInstance();
    protected LogEventSource logEventSource = LogEventSource.getInstance();
    protected GUIEventSource guiEventSource = GUIEventSource.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object element) {
        try {
            this.guiEventSource.fireEvent(new GUIEvent(this, GUIEventType.START));
            GetRevisionWorker worker = new GetRevisionWorker((ISVNFileItem)element);
            this.vmgr.getShell().getDisplay().syncExec((Runnable)worker);
            Object[] objectArray = worker.getKids();
            return objectArray;
        }
        finally {
            this.guiEventSource.fireEvent(new GUIEvent(this, GUIEventType.FINISH));
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object old_object, Object new_object) {
    }

    private class GetRevisionWorker
    implements Runnable {
        private ISVNFileItem fileItem = null;
        private Object[] kids = null;

        public GetRevisionWorker(ISVNFileItem fileItem) {
            this.fileItem = fileItem;
        }

        @Override
        public void run() {
            try {
                this.kids = this.fileItem.getRevisionInfo();
            }
            catch (InternalFailException ex) {
                RemoteFileTableContentProvider.this.logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
            }
        }

        public Object[] getKids() {
            return this.kids == null ? new Object[]{} : this.kids;
        }
    }
}

