/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view.localfs;

import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class FileTableLabelProvider
implements ITableLabelProvider {
    private final SystemBase sb = SystemBase.getInstance();

    public String getColumnText(Object element, int column_index) {
        switch (column_index) {
            default: {
                this.sb.getLogger().fatal((Object)("LocalTable\u63cf\u753b\u6642\u306b\u4e0d\u660e\u306a\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u756a\u53f7\u304c\u6e21\u3055\u308c\u307e\u3057\u305f\u3002" + column_index));
                return "";
            }
            case 0: {
                return ((ISVNFileItem)element).getName();
            }
            case 1: {
                long size = ((ISVNFileItem)element).getFilesize();
                if (size >= 0L) {
                    DecimalFormat decformat = new DecimalFormat("###,###,###,###");
                    return decformat.format(size);
                }
                return "";
            }
            case 2: {
                return ((ISVNFileItem)element).getLastCommitAuthor();
            }
            case 3: {
                String s = String.valueOf(((ISVNFileItem)element).getRevision());
                return s;
            }
            case 4: {
                String s = String.valueOf(((ISVNFileItem)element).getLastChangedRevision());
                return s;
            }
            case 5: {
                return ((ISVNFileItem)element).getLastChangedDate().toString();
            }
            case 6: {
                String url = ((ISVNFileItem)element).getURL();
                URI u = null;
                try {
                    u = new URI(url);
                }
                catch (URISyntaxException ex) {
                    this.sb.getLogger().fatal((Object)("LocalTable\u63cf\u753b\u6642\u306bURI\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(6)" + url));
                    return "";
                }
                return u.getHost();
            }
            case 7: {
                String url = ((ISVNFileItem)element).getURL();
                URI u = null;
                try {
                    u = new URI(url);
                }
                catch (URISyntaxException ex) {
                    this.sb.getLogger().fatal((Object)("LocalTable\u63cf\u753b\u6642\u306bURI\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(7)" + url));
                    return "";
                }
                return u.getPath();
            }
            case 8: 
        }
        return ((ISVNFileItem)element).getUUID();
    }

    public void addListener(ILabelProviderListener ilabelproviderlistener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object obj, String s) {
        return false;
    }

    public void removeListener(ILabelProviderListener ilabelproviderlistener) {
    }

    public Image getColumnImage(Object element, int column_index) {
        if (column_index != 0) {
            return null;
        }
        if (((ISVNFileItem)element).isDirectory()) {
            return ImageFactory.getInstance().getImage("folder");
        }
        String fileName = ((ISVNFileItem)element).getURL();
        return ImageFactory.getInstance().getAssociatedImageToFile(fileName);
    }
}

