/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view;

import com.interpress_project.modernshare.client.controller.actions.ActivateTargetAction;
import com.interpress_project.modernshare.client.controller.actions.ChangePasswordAction;
import com.interpress_project.modernshare.client.controller.actions.CheckOut2Action;
import com.interpress_project.modernshare.client.controller.actions.CheckOutAction;
import com.interpress_project.modernshare.client.controller.actions.DeActivateTargetAction;
import com.interpress_project.modernshare.client.controller.actions.DisableTargetAction;
import com.interpress_project.modernshare.client.controller.actions.ExportAction;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.actions.LocalExportAction;
import com.interpress_project.modernshare.client.controller.actions.LocalRefreshAction;
import com.interpress_project.modernshare.client.controller.actions.PropertyAction;
import com.interpress_project.modernshare.client.controller.actions.RefreshAction;
import com.interpress_project.modernshare.client.controller.actions.RegisterTargetAction;
import com.interpress_project.modernshare.client.controller.actions.RemoteDeleteAction;
import com.interpress_project.modernshare.client.controller.actions.SyncDataAction;
import com.interpress_project.modernshare.client.controller.actions.UnRegisterTargetAction;
import com.interpress_project.modernshare.client.controller.model.IFileItem;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalFile;
import com.interpress_project.modernshare.client.controller.model.LocalFolder;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RemoteModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNFile;
import com.interpress_project.modernshare.client.controller.model.SVNFolder;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.RemoteViewEvent;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.client.view.localfs.AllowOnlyFoldersFilter;
import com.interpress_project.modernshare.client.view.localfs.FileSorter;
import com.interpress_project.modernshare.client.view.localfs.FileTableContentProvider;
import com.interpress_project.modernshare.client.view.localfs.FileTableLabelProvider;
import com.interpress_project.modernshare.client.view.localfs.FileTreeContentProvider;
import com.interpress_project.modernshare.client.view.localfs.FileTreeLabelProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteAllowOnlyFoldersFilter;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileSorter;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTableContentProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTableLabelProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTreeContentProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTreeLabelProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteTreeFileSorter;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MfContents {
    private final ViewManager vmgr;
    private final SystemBase sb = SystemBase.getInstance();
    private TreeViewer treeLocalViewer;
    private TreeViewer treeRemoteViewer;
    private TableViewer tableLocalViewer;
    private TableViewer tableRemoteViewer;
    private Table tblAppLog;

    public MfContents(ViewManager vmgr, Composite parent0, int type) {
        this.vmgr = vmgr;
        Composite parent = new Composite(parent0, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        parent.setLayout((Layout)gridLayout);
        parent.setLayoutData((Object)new GridData(1808));
        SashForm sashform = new SashForm(parent, 512);
        GridData gridData = new GridData(1808);
        sashform.setLayoutData((Object)gridData);
        this.initFileViews((Composite)sashform);
        this.initLogView((Composite)sashform);
        sashform.setWeights(new int[]{4, 2});
    }

    private void initFileViews(Composite parent) {
        Display display = parent.getDisplay();
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setMaximizeVisible(true);
        tabFolder.setMinimizeVisible(true);
        tabFolder.setSimple(false);
        tabFolder.setTabHeight(24);
        tabFolder.setSelectionBackground(new Color[]{display.getSystemColor(31), display.getSystemColor(32)}, new int[]{90}, true);
        tabFolder.setSelectionForeground(display.getSystemColor(1));
        this.initLocalViewer(tabFolder);
        this.initRemoteViewer(tabFolder);
    }

    private void initLocalViewer(CTabFolder tabFolder) {
        Display display = tabFolder.getDisplay();
        Font font = new Font((Device)display, "MS UI Gothic", 9, 0);
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0(\u30ed\u30fc\u30ab\u30ebPC)");
        tabItem.setImage(ImageFactory.getInstance().getImage("localpc"));
        SashForm sashform = new SashForm((Composite)tabFolder, 256);
        ViewForm vfTreeView = new ViewForm((Composite)sashform, 0x800800);
        vfTreeView.setLayoutData((Object)new GridData(1808));
        vfTreeView.setTopCenterSeparate(false);
        CLabel clabel = new CLabel((Composite)vfTreeView, 0);
        clabel.setText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0");
        vfTreeView.setTopLeft((Control)clabel);
        this.treeLocalViewer = new TreeViewer((Composite)vfTreeView, 768);
        this.treeLocalViewer.getTree().setFont(font);
        this.treeLocalViewer.setContentProvider((IContentProvider)new FileTreeContentProvider());
        this.treeLocalViewer.setLabelProvider((IBaseLabelProvider)new FileTreeLabelProvider());
        this.treeLocalViewer.addFilter((ViewerFilter)new AllowOnlyFoldersFilter());
        this.treeLocalViewer.setSorter((ViewerSorter)new FileSorter());
        vfTreeView.setContent((Control)this.treeLocalViewer.getTree());
        this.treeLocalViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selected = (IStructuredSelection)event.getSelection();
                if (!selected.isEmpty()) {
                    Object selectedObject = selected.getFirstElement();
                    if (selectedObject instanceof LocalRoot) {
                        return;
                    }
                    if (selectedObject instanceof LocalFolder || selectedObject instanceof LocalFile) {
                        // empty if block
                    }
                    MfContents.this.tableLocalViewer.setInput(selectedObject);
                }
            }
        });
        MenuManager tv_menu_manager = new MenuManager();
        this.treeLocalViewer.getTree().setMenu(tv_menu_manager.createContextMenu((Control)this.treeLocalViewer.getTree()));
        tv_menu_manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menumgr) {
                Tree tree = MfContents.this.treeLocalViewer.getTree();
                TreeItem[] treeItems = tree.getSelection();
                menumgr.setRemoveAllWhenShown(true);
                if (treeItems.length > 0) {
                    menumgr.add((IAction)new LocalRefreshAction(MfContents.this.vmgr));
                    menumgr.add((IContributionItem)new Separator());
                    IFileItem fileItem = (IFileItem)treeItems[0].getData();
                    if (fileItem instanceof LocalRoot) {
                        switch (((LocalRoot)fileItem).getStatus()) {
                            case active: {
                                menumgr.add((IAction)new DeActivateTargetAction(MfContents.this.vmgr, fileItem.getAbsolutePath()));
                                menumgr.add((IContributionItem)new Separator());
                                menumgr.add((IAction)new SyncDataAction(MfContents.this.vmgr, (LocalRoot)fileItem));
                                break;
                            }
                            case deactive: {
                                menumgr.add((IAction)new ActivateTargetAction(MfContents.this.vmgr, (LocalRoot)fileItem));
                                menumgr.add((IContributionItem)new Separator());
                                menumgr.add((IAction)new SyncDataAction(MfContents.this.vmgr, (LocalRoot)fileItem));
                                break;
                            }
                        }
                        menumgr.add((IAction)new DisableTargetAction(MfContents.this.vmgr, fileItem.getAbsolutePath()));
                        menumgr.add((IAction)new UnRegisterTargetAction(MfContents.this.vmgr, fileItem.getAbsolutePath(), fileItem.getName()));
                    } else if (fileItem instanceof LocalFolder) {
                        menumgr.add((IAction)new LocalExportAction(MfContents.this.vmgr, fileItem.getAbsolutePath()));
                        menumgr.add((IAction)new ChangePasswordAction(MfContents.this.vmgr));
                    } else if (fileItem instanceof LocalFile) {
                        menumgr.add((IAction)new LocalExportAction(MfContents.this.vmgr, fileItem.getAbsolutePath()));
                        menumgr.add((IAction)new PropertyAction(MfContents.this.vmgr));
                    }
                } else {
                    menumgr.add((IAction)new RegisterTargetAction(MfContents.this.vmgr));
                    menumgr.add((IAction)new CheckOutAction(MfContents.this.vmgr));
                }
            }
        });
        this.tableLocalViewer = new TableViewer((Composite)sashform, 0x10010300);
        this.tableLocalViewer.getTable().setFont(font);
        this.tableLocalViewer.getTable().setHeaderVisible(true);
        this.tableLocalViewer.setContentProvider((IContentProvider)new FileTableContentProvider());
        this.tableLocalViewer.setLabelProvider((IBaseLabelProvider)new FileTableLabelProvider());
        this.tableLocalViewer.setSorter((ViewerSorter)new FileSorter());
        TableColumn column = null;
        column = new TableColumn(this.tableLocalViewer.getTable(), 16384);
        column.setText("\u540d\u524d");
        column.setWidth(170);
        column = new TableColumn(this.tableLocalViewer.getTable(), 131072);
        column.setText("\u30b5\u30a4\u30ba");
        column.setWidth(66);
        column = new TableColumn(this.tableLocalViewer.getTable(), 16384);
        column.setText("\u5909\u66f4\u8005");
        column.setWidth(76);
        column = new TableColumn(this.tableLocalViewer.getTable(), 131072);
        column.setText("\u30ea\u30d3\u30b8\u30e7\u30f3");
        column.setWidth(56);
        column = new TableColumn(this.tableLocalViewer.getTable(), 131072);
        column.setText("\u30ea\u30d3\u30b8\u30e7\u30f3(\u6700\u7d42\u5909\u66f4)");
        column.setWidth(116);
        column = new TableColumn(this.tableLocalViewer.getTable(), 16384);
        column.setText("\u66f4\u65b0\u65e5\u6642");
        column.setWidth(172);
        column = new TableColumn(this.tableLocalViewer.getTable(), 16384);
        column.setText("\u683c\u7d0d\u30db\u30b9\u30c8(\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf)");
        column.setWidth(132);
        column = new TableColumn(this.tableLocalViewer.getTable(), 16384);
        column.setText("\u683c\u7d0d\u30d1\u30b9(\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf)");
        column.setWidth(226);
        column = new TableColumn(this.tableLocalViewer.getTable(), 16384);
        column.setText("UUID");
        column.setWidth(226);
        tabItem.setControl((Control)sashform);
        sashform.setWeights(new int[]{2, 3});
        tabFolder.setSelection(0);
    }

    private void initRemoteViewer(CTabFolder tabFolder) {
        Display display = tabFolder.getDisplay();
        Font font = new Font((Device)display, "MS UI Gothic", 9, 0);
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30ea\u30dd\u30b8\u30c8\u30ea(\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf)");
        tabItem.setImage(ImageFactory.getInstance().getImage("remotepc"));
        SashForm sashform = new SashForm((Composite)tabFolder, 256);
        ViewForm vfTreeView = new ViewForm((Composite)sashform, 0x800800);
        vfTreeView.setLayoutData((Object)new GridData(1808));
        vfTreeView.setTopCenterSeparate(false);
        CLabel clabel = new CLabel((Composite)vfTreeView, 0);
        clabel.setText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30ea\u30dd\u30b8\u30c8\u30ea(\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf)");
        vfTreeView.setTopLeft((Control)clabel);
        this.treeRemoteViewer = new TreeViewer((Composite)vfTreeView, 770);
        this.treeRemoteViewer.getTree().setFont(font);
        this.treeRemoteViewer.setContentProvider((IContentProvider)new RemoteFileTreeContentProvider());
        this.treeRemoteViewer.setLabelProvider((IBaseLabelProvider)new RemoteFileTreeLabelProvider());
        this.treeRemoteViewer.addFilter((ViewerFilter)new RemoteAllowOnlyFoldersFilter());
        this.treeRemoteViewer.setSorter((ViewerSorter)new RemoteTreeFileSorter());
        this.treeRemoteViewer.setInput((Object)RemoteModelManager.getInstance().getRootLineItem());
        vfTreeView.setContent((Control)this.treeRemoteViewer.getTree());
        this.treeRemoteViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewer tv = (TreeViewer)event.getSource();
                IStructuredSelection selected = (IStructuredSelection)event.getSelection();
                if (!selected.isEmpty()) {
                    Object selectedObject = selected.getFirstElement();
                    if (selectedObject instanceof SVNRoot) {
                        return;
                    }
                    if (selectedObject instanceof SVNFolder) {
                        tv.expandToLevel(selectedObject, 1);
                        MfContents.this.tableRemoteViewer.setInput(selectedObject);
                    } else if (selectedObject instanceof SVNFile) {
                        MfContents.this.tableRemoteViewer.setInput(selectedObject);
                    }
                }
            }
        });
        MenuManager tv_remote_menu_manager = new MenuManager();
        this.treeRemoteViewer.getTree().setMenu(tv_remote_menu_manager.createContextMenu((Control)this.treeRemoteViewer.getTree()));
        tv_remote_menu_manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menumgr) {
                Tree tree = MfContents.this.treeRemoteViewer.getTree();
                TreeItem[] treeItems = tree.getSelection();
                ISVNFileItem[] items = new ISVNFileItem[treeItems.length];
                for (int i = 0; i < treeItems.length; ++i) {
                    items[i] = (ISVNFileItem)treeItems[i].getData();
                }
                menumgr.setRemoveAllWhenShown(true);
                if (items.length == 0) {
                    menumgr.add((IAction)new RefreshAction(MfContents.this.vmgr));
                    return;
                }
                if (items.length == 1) {
                    if (items[0] instanceof SVNRoot) {
                        LocalModelManager lmmgr = LocalModelManager.getInstance();
                        if (lmmgr.canRegisterMore() && !lmmgr.isExistTagnameInRocal(((SVNRoot)items[0]).getName())) {
                            menumgr.add((IAction)new CheckOut2Action(MfContents.this.vmgr, (SVNRoot)items[0]));
                            menumgr.add((IContributionItem)new Separator());
                        }
                        menumgr.add((IAction)new ExportAction(MfContents.this.vmgr, items[0]));
                        menumgr.add((IAction)new RemoteDeleteAction(MfContents.this.vmgr, items));
                        menumgr.add((IContributionItem)new Separator());
                        menumgr.add((IAction)new RefreshAction(MfContents.this.vmgr));
                    } else {
                        menumgr.add((IAction)new ExportAction(MfContents.this.vmgr, items[0]));
                        menumgr.add((IAction)new RemoteDeleteAction(MfContents.this.vmgr, items));
                        menumgr.add((IContributionItem)new Separator());
                        menumgr.add((IAction)new RefreshAction(MfContents.this.vmgr));
                    }
                } else {
                    menumgr.add((IAction)new RemoteDeleteAction(MfContents.this.vmgr, items));
                }
            }
        });
        this.tableRemoteViewer = new TableViewer((Composite)sashform, 0x10010800);
        this.tableRemoteViewer.getTable().setFont(font);
        this.tableRemoteViewer.getTable().setHeaderVisible(true);
        this.tableRemoteViewer.setContentProvider((IContentProvider)new RemoteFileTableContentProvider());
        this.tableRemoteViewer.setLabelProvider((IBaseLabelProvider)new RemoteFileTableLabelProvider());
        this.tableRemoteViewer.setSorter((ViewerSorter)new RemoteFileSorter());
        MenuManager tbl_remote_menu_manager = new MenuManager();
        this.tableRemoteViewer.getTable().setMenu(tbl_remote_menu_manager.createContextMenu((Control)this.tableRemoteViewer.getTable()));
        tbl_remote_menu_manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menumgr) {
                TableItem[] tableItems = MfContents.this.tableRemoteViewer.getTable().getSelection();
                if (tableItems.length > 0) {
                    ISVNFileItem item = (ISVNFileItem)tableItems[0].getData();
                    menumgr.setRemoveAllWhenShown(true);
                    menumgr.add((IAction)new ExportAction(MfContents.this.vmgr, item));
                }
            }
        });
        TableColumn column = null;
        column = new TableColumn(this.tableRemoteViewer.getTable(), 16384);
        column.setText("\u540d\u524d");
        column.setWidth(180);
        column = new TableColumn(this.tableRemoteViewer.getTable(), 131072);
        column.setText("\u30ea\u30d3\u30b8\u30e7\u30f3");
        column.setWidth(76);
        column = new TableColumn(this.tableRemoteViewer.getTable(), 131072);
        column.setText("\u30ea\u30d3\u30b8\u30e7\u30f3(\u6700\u7d42\u5909\u66f4)");
        column.setWidth(120);
        column = new TableColumn(this.tableRemoteViewer.getTable(), 16384);
        column.setText("\u5909\u66f4\u8005");
        column.setWidth(80);
        column = new TableColumn(this.tableRemoteViewer.getTable(), 16384);
        column.setText("\u66f4\u65b0\u65e5\u6642");
        column.setWidth(180);
        column = new TableColumn(this.tableRemoteViewer.getTable(), 16384);
        column.setText("\u683c\u7d0d\u30d1\u30b9(\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf)");
        column.setWidth(180);
        column = new TableColumn(this.tableRemoteViewer.getTable(), 16384);
        column.setText("UUID");
        column.setWidth(240);
        sashform.setWeights(new int[]{2, 3});
        tabItem.setControl((Control)sashform);
    }

    private void initLogView(Composite parent) {
        Display display = parent.getDisplay();
        ViewForm vfLogView = new ViewForm(parent, 0x800800);
        vfLogView.setLayoutData((Object)new GridData(1808));
        vfLogView.setTopCenterSeparate(false);
        CLabel clabel = new CLabel((Composite)vfLogView, 0);
        clabel.setText("\u30b7\u30b9\u30c6\u30e0\u60c5\u5831\u30ed\u30b0");
        vfLogView.setTopLeft((Control)clabel);
        this.tblAppLog = new Table((Composite)vfLogView, 268438280);
        this.tblAppLog.setBackground(new Color((Device)display, 255, 255, 255));
        this.tblAppLog.setHeaderVisible(true);
        this.tblAppLog.setLinesVisible(true);
        TableColumn column = null;
        column = new TableColumn(this.tblAppLog, 0x1000000);
        column.setText("");
        column.setWidth(22);
        column = new TableColumn(this.tblAppLog, 16384);
        column.setText("\u65e5\u6642");
        column.setWidth(192);
        column = new TableColumn(this.tblAppLog, 16384);
        column.setText("\u6982\u8981");
        column.setWidth(640);
        vfLogView.setContent((Control)this.tblAppLog);
    }

    public void updateLocalViewer(LocalViewEvent event) {
        Shell shell = this.vmgr.getShell();
        if (shell == null) {
            return;
        }
        shell.getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MfContents.this.treeLocalViewer.getTree().setRedraw(false);
                try {
                    Object[] objs = MfContents.this.treeLocalViewer.getExpandedElements();
                    MfContents.this.treeLocalViewer.setInput((Object)LocalModelManager.getInstance().getRootLineItem());
                    MfContents.this.treeLocalViewer.setExpandedElements(objs);
                    MfContents.this.tableLocalViewer.setInput(null);
                    MfContents.this.tableLocalViewer.getTable().clearAll();
                    MfContents.this.tableLocalViewer.getTable().setItemCount(0);
                }
                finally {
                    MfContents.this.treeLocalViewer.getTree().setRedraw(true);
                }
            }
        });
    }

    public void updateRemoteViewer(RemoteViewEvent event) {
        Shell shell = this.vmgr.getShell();
        if (shell == null) {
            return;
        }
        shell.getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MfContents.this.treeRemoteViewer.getTree().setRedraw(false);
                try {
                    MfContents.this.treeRemoteViewer.setInput((Object)RemoteModelManager.getInstance().getRootLineItem());
                    MfContents.this.treeRemoteViewer.expandToLevel(1);
                    MfContents.this.tableRemoteViewer.setInput(null);
                    MfContents.this.tableRemoteViewer.getTable().clearAll();
                    MfContents.this.tableRemoteViewer.getTable().setItemCount(0);
                }
                finally {
                    MfContents.this.treeRemoteViewer.getTree().setRedraw(true);
                }
            }
        });
    }

    public void updateAppLog(final LogEvent event) {
        Shell shell = this.vmgr.getShell();
        if (shell == null) {
            return;
        }
        if (this.tblAppLog == null) {
            return;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                int line_count = MfContents.this.tblAppLog.getItemCount();
                if (line_count > 300) {
                    MfContents.this.tblAppLog.clear(0, 100);
                }
                switch (event.getLogEventType()) {
                    default: {
                        String date = MfContents.this.sb.getDateUtil().getDateTimeAsFullString(new Date());
                        TableItem tableItem = new TableItem(MfContents.this.tblAppLog, 0);
                        tableItem.setText(new String[]{"", date, event.getMessage()});
                        if (event.getLogEventType() == LogEventType.ERROR) {
                            tableItem.setImage(0, ImageFactory.getInstance().getImage("disable"));
                            MfContents.this.sb.getLogger().error((Object)event.getMessage(), (Throwable)event.getException());
                        } else {
                            MfContents.this.sb.getLogger().info((Object)event.getMessage());
                        }
                        MfContents.this.tblAppLog.setTopIndex(MfContents.this.tblAppLog.getItemCount() - 3);
                        break;
                    }
                    case CLEAR: {
                        MfContents.this.tblAppLog.clearAll();
                        MfContents.this.tblAppLog.setItemCount(0);
                    }
                }
                MfContents.this.tblAppLog.update();
            }
        });
    }
}

