/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.view;

import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.client.view.preference.ClientPreferenceDialog;
import com.interpress_project.modernshare.client.view.wizard.ChangePasswordWizard;
import com.interpress_project.modernshare.client.view.wizard.CheckoutWizard;
import com.interpress_project.modernshare.client.view.wizard.LocalExportWizard;
import com.interpress_project.modernshare.client.view.wizard.RegisterTargetFolderWizard;
import com.interpress_project.modernshare.client.view.wizard.RemoteExportWizard;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DialogManager {
    private final ViewManager vmgr;
    private boolean bAnswer;

    public DialogManager(ViewManager vmgr) {
        this.vmgr = vmgr;
    }

    public void createErrorMessageDialog(String desc) {
        String _title = "\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8";
        final String _desc = desc;
        this.vmgr.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)DialogManager.this.vmgr.getShell(), (String)"\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8", (String)_desc);
            }
        });
    }

    public void createInformationMessageDialog(String title, String desc) {
        final String _title = title;
        final String _desc = desc;
        this.vmgr.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)DialogManager.this.vmgr.getShell(), (String)_title, (String)_desc);
            }
        });
    }

    public boolean createYesNoMessageDialog(final String title, final String desc) {
        this.vmgr.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DialogManager.this.bAnswer = MessageDialog.openQuestion((Shell)DialogManager.this.vmgr.getShell(), (String)title, (String)desc);
            }
        });
        return this.bAnswer;
    }

    public String createDirectoryDialog(String title, String path) {
        DirectoryDialog dialog = new DirectoryDialog(this.vmgr.getShell());
        dialog.setFilterPath(path);
        dialog.setMessage(title);
        return dialog.open();
    }

    public void createTargetFolderWizard(ArrayList<SVNRoot> list) {
        RegisterTargetFolderWizard regWizard = new RegisterTargetFolderWizard(list);
        WizardDialog dlg = new WizardDialog(this.vmgr.getShell(), (IWizard)regWizard);
        dlg.setPageSize(500, 190);
        dlg.open();
    }

    public void createCheckoutWizard(ArrayList<SVNRoot> list) {
        CheckoutWizard checkoutWizard = new CheckoutWizard(list);
        WizardDialog dlg = new WizardDialog(this.vmgr.getShell(), (IWizard)checkoutWizard);
        dlg.setPageSize(500, 190);
        dlg.open();
    }

    public void createChangePasswordWizard() {
        ChangePasswordWizard chgPwdWizard = new ChangePasswordWizard();
        WizardDialog dlg = new WizardDialog(this.vmgr.getShell(), (IWizard)chgPwdWizard);
        dlg.setPageSize(500, 190);
        dlg.open();
    }

    public void createLocalExportWizard(ArrayList<ISVNFileItem> revlist) {
        LocalExportWizard wizard = new LocalExportWizard(revlist);
        WizardDialog dlg = new WizardDialog(this.vmgr.getShell(), (IWizard)wizard);
        dlg.setPageSize(500, 190);
        dlg.open();
    }

    public void createRemoteExportWizard(ISVNFileItem item) {
        RemoteExportWizard wizard = new RemoteExportWizard(item);
        WizardDialog dlg = new WizardDialog(this.vmgr.getShell(), (IWizard)wizard);
        dlg.setPageSize(500, 190);
        dlg.open();
    }

    public void createPreferenceDialog() {
        ClientPreferenceDialog dlg = new ClientPreferenceDialog(this.vmgr.getShell());
        dlg.run();
    }

    public String openSaveDialog(String baseName) {
        FileDialog dlg = new FileDialog(this.vmgr.getShell(), 8192);
        dlg.setFileName(baseName);
        dlg.setFilterNames(new String[]{"All Files (*.*)"});
        String fileName = dlg.open();
        return fileName;
    }

    public int createSyncModeDialog() {
        SyncModeDialog dlg = new SyncModeDialog(this.vmgr);
        int result = dlg.open();
        return result;
    }

    private class SyncModeDialog
    extends TitleAreaDialog {
        private Button b1;
        private Button b2;

        public SyncModeDialog(ViewManager vmgr) {
            super(vmgr.getShell());
        }

        protected Control createDialogArea(Composite composite) {
            PropertyManager propmgr = PropertyManager.getInstance();
            this.setTitle("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3068\u306e\u540c\u671f\u51e6\u7406");
            this.setMessage("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u3068\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u9593\u3067\u540c\u671f\u51e6\u7406\u3092\u884c\u3044\u307e\u3059\u3002\u540c\u671f\u30dd\u30ea\u30b7\u30fc\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 0);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            layout.numColumns = 1;
            layout.marginTop = 4;
            layout.marginLeft = 4;
            layout.marginRight = 4;
            Group g = new Group(composite, 16);
            GridData gd = new GridData(768);
            g.setLayoutData((Object)gd);
            g.setLayout((Layout)new RowLayout(512));
            g.setText("\u540c\u671f\u30dd\u30ea\u30b7\u30fc\u306e\u9078\u629e");
            this.b1 = new Button((Composite)g, 16);
            this.b1.setText("\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306e\u5185\u5bb9\u3067\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3092\u66f4\u65b0(PC HotShot Folder -> Data Center)");
            this.b2 = new Button((Composite)g, 16);
            this.b2.setText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u5185\u5bb9\u3067\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u3092\u66f4\u65b0(DataCenter -> PC HotShot Folder)");
            if (propmgr.isPc2Host()) {
                this.b1.setSelection(true);
            } else {
                this.b2.setSelection(true);
            }
            return composite;
        }

        protected boolean canHandleShellCloseEvent() {
            return false;
        }

        protected void buttonPressed(int buttonId) {
            PropertyManager propmgr = PropertyManager.getInstance();
            if (0 == buttonId) {
                if (this.b1.getSelection()) {
                    propmgr.setPc2Host(true);
                    this.setReturnCode(0);
                } else {
                    propmgr.setPc2Host(false);
                    this.setReturnCode(1);
                }
            } else {
                this.setReturnCode(-1);
            }
            this.close();
        }
    }
}

