/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SVNItemCache {
    private final PropertyManager propmgr = PropertyManager.getInstance();
    private List<ISVNFileItem> arrList = Collections.synchronizedList(new ArrayList(this.propmgr.getMaxCache() + 1));

    public void addSVNFileItem(ISVNFileItem item) {
        int sz = this.arrList.size();
        if (sz > this.propmgr.getMaxCache() - 1) {
            this.arrList.remove(sz - 1);
        }
        this.arrList.add(item);
    }

    public ArrayList<ISVNFileItem> getSVNFileItem() {
        Collections.sort(this.arrList, new Comparator(){

            public int compare(Object element0, Object element1) {
                long r1;
                long r0 = ((ISVNFileItem)element0).getRevision();
                return r0 > (r1 = ((ISVNFileItem)element1).getRevision()) ? 0 : 1;
            }
        });
        return new ArrayList<ISVNFileItem>(this.arrList);
    }

    public boolean isCached(ISVNFileItem item) {
        for (int i = 0; i < this.arrList.size(); ++i) {
            ISVNFileItem l = this.arrList.get(i);
            if (l.getRevision() != item.getRevision() || l.getLastChangedRevision() != item.getLastChangedRevision()) continue;
            return true;
        }
        return false;
    }
}

