/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import java.util.ArrayList;
import java.util.Date;

public class SVNFile
implements ISVNFileItem {
    private String name;
    private long fileSize;
    private String author;
    private long revision;
    private long lastChangedRevision;
    private Date lastChangedDate;
    private String url;
    private String uuid;

    public SVNFile(String name, long fileSize, String author, Date lastChangedDate, long revision, long lastChangedRevision, String url, String uuid) {
        this.name = name;
        this.fileSize = fileSize;
        this.author = author;
        this.lastChangedDate = lastChangedDate;
        this.revision = revision;
        this.lastChangedRevision = lastChangedRevision;
        this.url = url;
        this.uuid = uuid;
    }

    @Override
    public long getFilesize() {
        return this.fileSize;
    }

    @Override
    public Date getLastChangedDate() {
        return this.lastChangedDate;
    }

    @Override
    public long getLastChangedRevision() {
        return this.lastChangedRevision;
    }

    @Override
    public String getLastCommitAuthor() {
        return this.author;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public ISVNFileItem[] getSVNItems() {
        return null;
    }

    @Override
    public ISVNFileItem[] getRevisionInfo() throws InternalFailException {
        ArrayList<ISVNFileItem> list = null;
        RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
        list = svnmgr.getRevisionInfo(this.url);
        return list.toArray(new ISVNFileItem[list.size()]);
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }
}

