/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.SVNItemCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SVNCacheManager {
    private Map<String, SVNItemCache> mapSVNItemCache = Collections.synchronizedMap(new HashMap());

    public void addSVNFileItem(ISVNFileItem item) {
        String url = item.getURL();
        SVNItemCache cache = this.mapSVNItemCache.get(url);
        if (cache == null) {
            cache = new SVNItemCache();
        }
        cache.addSVNFileItem(item);
        this.mapSVNItemCache.put(url, cache);
    }

    public ArrayList<ISVNFileItem> getSVNFileItems(String url) {
        SVNItemCache cache = this.mapSVNItemCache.get(url);
        if (cache == null) {
            return null;
        }
        return cache.getSVNFileItem();
    }

    public boolean isCached(ISVNFileItem item) {
        String url = item.getURL();
        SVNItemCache cache = this.mapSVNItemCache.get(url);
        if (cache == null) {
            return false;
        }
        return cache.isCached(item);
    }

    public int getCurrentCacheSize() {
        return this.mapSVNItemCache.size();
    }
}

