/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.model.IFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class LocalRootLineItem
implements IFileItem {
    Hashtable<String, LocalRoot> htTargetFolders = new Hashtable();

    public void addRoot(LocalRoot root) {
        this.htTargetFolders.put(root.getAbsolutePath(), root);
    }

    public boolean canRegisterMore() {
        LocalRoot[] roots = this.getRoots();
        return roots.length < 4;
    }

    public void removeRoot(String path) {
        LocalRoot root = this.getRoot(path);
        if (root == null) {
            return;
        }
        this.htTargetFolders.remove(path);
    }

    public void removeRootByTagname(String tagname) {
        Enumeration<LocalRoot> e = this.htTargetFolders.elements();
        while (e.hasMoreElements()) {
            LocalRoot root = e.nextElement();
            if (!root.getName().equals(tagname)) continue;
            this.htTargetFolders.remove(root.getAbsolutePath());
            break;
        }
    }

    public LocalRoot[] getRoots() {
        ArrayList<LocalRoot> arrayList = new ArrayList<LocalRoot>();
        this.checkDisableStatus();
        Enumeration<LocalRoot> enumeration = this.htTargetFolders.elements();
        while (enumeration.hasMoreElements()) {
            LocalRoot item = enumeration.nextElement();
            arrayList.add(item);
        }
        return arrayList.toArray(new LocalRoot[arrayList.size()]);
    }

    public LocalRoot[] getActiveRoots() {
        ArrayList<LocalRoot> arrayList = new ArrayList<LocalRoot>();
        this.checkDisableStatus();
        Enumeration<LocalRoot> enumeration = this.htTargetFolders.elements();
        block3: while (enumeration.hasMoreElements()) {
            LocalRoot item = enumeration.nextElement();
            switch (item.getStatus()) {
                default: {
                    continue block3;
                }
                case active: 
            }
            arrayList.add(item);
        }
        return arrayList.toArray(new LocalRoot[arrayList.size()]);
    }

    private void checkDisableStatus() {
        Enumeration<LocalRoot> enumeration = this.htTargetFolders.elements();
        while (enumeration.hasMoreElements()) {
            LocalRoot item = enumeration.nextElement();
            if (new File(item.getAbsolutePath()).exists()) continue;
            item.setStatus(RootStatus.disable);
        }
    }

    public boolean isExistTagnameInRocal(String tagName) {
        LocalRoot[] localRoots = this.getRoots();
        for (int i = 0; i < localRoots.length; ++i) {
            if (!localRoots[i].getName().equalsIgnoreCase(tagName)) continue;
            return true;
        }
        return false;
    }

    public LocalRoot getRoot(String path) {
        return this.htTargetFolders.get(path);
    }

    @Override
    public String getAbsolutePath() {
        return null;
    }

    @Override
    public long getFilesize() {
        return 0L;
    }

    @Override
    public IFileItem[] getLocalItems() {
        return this.getRoots();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public IFileItem getParent() {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isExist() {
        return true;
    }

    public void dispose() {
        LocalRoot[] roots = this.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            roots[i].dispose();
        }
    }
}

