/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.model.FsWatcherManager;
import com.interpress_project.modernshare.client.controller.model.LocalFolder;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;

public class LocalRoot
extends LocalFolder
implements FileSystemEventListener {
    private FsWatcherManager fsmgr = null;
    private String tagName;
    private RootStatus status;
    private boolean bPc2host;
    private boolean bDirty;

    public LocalRoot(String path, String tagName, RootStatus status, boolean bPc2host) {
        super(path);
        this.fsmgr = new FsWatcherManager(path);
        this.tagName = tagName;
        this.setStatus(status);
        this.setPc2host(bPc2host);
        this.setDirty(false);
    }

    @Override
    public String getName() {
        return this.tagName;
    }

    public void setStatus(RootStatus status) {
        this.status = status;
        if (RootStatus.active == status) {
            this.fsmgr.addFileSystemListener(this);
            this.fsmgr.start();
        } else {
            this.fsmgr.removeFileSystemListener(this);
            this.fsmgr.stop();
        }
    }

    public RootStatus getStatus() {
        return this.status;
    }

    public void setPc2host(boolean b) {
        this.bPc2host = b;
    }

    public boolean getPc2host() {
        return this.bPc2host;
    }

    public void setDirty(boolean b) {
        this.bDirty = b;
    }

    public boolean isDirty() {
        return this.bDirty;
    }

    @Override
    public void handle(FileSystemEvent event) {
        this.setDirty(true);
    }

    public void startFsWatcher() {
        this.fsmgr.start();
    }

    public void stopFsWatcher() {
        this.fsmgr.stop();
    }

    public void dispose() {
        this.fsmgr.dispose();
    }
}

