/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.LocalRootLineItem;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.XmlDAOManager;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LocalViewEventSource;
import com.interpress_project.modernshare.client.events.ViewEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import org.apache.commons.io.FilenameUtils;

public class LocalModelManager {
    private final SystemBase sb = SystemBase.getInstance();
    private final LocalViewEventSource localViewEventSource = LocalViewEventSource.getInstance();
    private final String filesep = this.sb.getFileSeparator();
    private LocalRootLineItem lineItem = null;
    private XmlDAOManager daomgr = new XmlDAOManager();
    private static LocalModelManager instance;

    protected LocalModelManager() {
        this.lineItem = new LocalRootLineItem();
    }

    public static LocalModelManager getInstance() {
        if (instance == null) {
            instance = new LocalModelManager();
        }
        return instance;
    }

    public void load() {
        this.daomgr.load();
        this.daomgr.needXMLSave(false);
        LocalRoot[] localRoots = this.daomgr.getLocalRoots();
        for (int i = 0; i < localRoots.length; ++i) {
            this.lineItem.addRoot(localRoots[i]);
        }
    }

    public void addRoot(String path, String name, RootStatus status, boolean bPc2host) {
        LocalRoot root = new LocalRoot(path, name, status, bPc2host);
        this.lineItem.addRoot(root);
        this.daomgr.setLocalRoots(this.lineItem.getRoots());
        this.daomgr.save();
        this.daomgr.needXMLSave(true);
        this.localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));
    }

    public boolean canRegisterMore() {
        return this.lineItem.canRegisterMore();
    }

    public void removeRoot(String path) {
        this.lineItem.removeRoot(path);
        this.daomgr.setLocalRoots(this.lineItem.getRoots());
        this.daomgr.save();
        this.daomgr.needXMLSave(true);
        this.localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));
    }

    public void removeRootByTagname(String tagname) {
        this.lineItem.removeRootByTagname(tagname);
        this.daomgr.save();
        this.daomgr.needXMLSave(true);
        this.localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));
    }

    public void setStatus(String path, RootStatus status) {
        LocalRoot root = this.lineItem.getRoot(path);
        if (root == null) {
            return;
        }
        root.setStatus(status);
        this.daomgr.setLocalRoots(this.lineItem.getRoots());
        this.daomgr.save();
        this.daomgr.needXMLSave(true);
        this.localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));
    }

    public boolean isPathOverwrapped(String path) {
        String newpath = FilenameUtils.getFullPath((String)(path + this.filesep));
        LocalRoot[] root = this.lineItem.getRoots();
        for (int i = 0; i < root.length; ++i) {
            String a2;
            String a1;
            String existpath = FilenameUtils.getFullPath((String)(root[i].getAbsolutePath() + this.filesep));
            if (newpath.length() > existpath.length()) {
                a1 = newpath;
                a2 = existpath;
            } else {
                a1 = existpath;
                a2 = newpath;
            }
            if (a1.indexOf(a2) == -1) continue;
            return true;
        }
        return false;
    }

    public boolean isExistTagnameInRocal(String tagName) {
        return this.lineItem.isExistTagnameInRocal(tagName);
    }

    public LocalRootLineItem getRootLineItem() {
        return this.lineItem;
    }

    public boolean hasXMLLoaded() {
        return this.daomgr.hasXMLLoaded();
    }

    public boolean needXMLSave() {
        return this.daomgr.needXMLSave();
    }

    public void needXMLSave(boolean b) {
        this.daomgr.needXMLSave(b);
    }

    public void dispose() {
        if (this.daomgr != null) {
            this.daomgr.setLocalRoots(this.lineItem.getRoots());
            this.daomgr.save();
        }
        this.lineItem.dispose();
    }
}

