/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.model;

import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;
import com.jniwrapper.win32.io.FileSystemException;
import com.jniwrapper.win32.io.FileSystemWatcher;
import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class FsWatcherManager {
    private SystemBase sb = SystemBase.getInstance();
    private FileSystemWatcher watcher = null;
    private TaskManager taskmgr = TaskManager.getInstance();
    private FsEventListener listener = null;
    private String rootpath = null;

    public FsWatcherManager(String rootpath) {
        this.sb.getLogger().debug((Object)(rootpath + " is registered as watcher point."));
        this.rootpath = rootpath;
        this.watcher = new FileSystemWatcher(rootpath, new OmitFileFilter(), true);
        this.listener = new FsEventListener();
        FileSystemWatcher.WatcherOptions options = this.watcher.getOptions();
        options.setNotifyChangeAttributes(false);
        options.setNotifyChangeDirName(true);
        options.setNotifyChangeFileName(true);
        options.setNotifyChangeSize(true);
        options.setNotifyLastAccess(false);
        options.setNotifyLastModified(false);
    }

    public void addFileSystemListener(FileSystemEventListener listener) {
        this.watcher.addFileSystemListener(listener);
    }

    public void removeFileSystemListener(FileSystemEventListener listener) {
        this.watcher.removeFileSystemListener(listener);
    }

    public void start() {
        if (this.watcher.isWatching()) {
            this.watcher.stop();
            this.watcher.removeFileSystemListener(this.listener);
        }
        this.watcher.addFileSystemListener(this.listener);
        try {
            this.watcher.start();
        }
        catch (FileSystemException ex) {
            this.sb.getLogger().error((Object)("FsWatcherManager for " + this.rootpath + " failed."));
            return;
        }
        this.sb.getLogger().debug((Object)("FsWatcherManager for " + this.rootpath + " started."));
    }

    public void stop() {
        if (this.watcher.isWatching()) {
            this.watcher.stop();
        }
        this.watcher.removeFileSystemListener(this.listener);
        this.sb.getLogger().debug((Object)("FsWatcherManager for " + this.rootpath + " stopped."));
    }

    public void dispose() {
        this.stop();
        this.watcher = null;
        this.sb.getLogger().debug((Object)("FsWatcherManager for " + this.rootpath + " disposed."));
    }

    private class OmitFileFilter
    implements FileFilter {
        private PropertyManager propmgr = PropertyManager.getInstance();
        private String[] filters = this.propmgr.getIgnoreFilterList();

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getAbsolutePath();
            String name = FilenameUtils.getName((String)path);
            if (FilenameUtils.wildcardMatchOnSystem((String)path, (String)"*\\.svn\\*")) {
                return false;
            }
            for (int i = 0; i < this.filters.length; ++i) {
                if (!FilenameUtils.wildcardMatchOnSystem((String)name, (String)this.filters[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class FsEventListener
    implements FileSystemEventListener {
        private FsEventListener() {
        }

        @Override
        public void handle(FileSystemEvent event) {
            String fname = event.getFileInfo().getFileName();
            FsWatcherManager.this.taskmgr.updateSchedule(fname);
        }
    }
}

