/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate;

import com.interpress_project.modernshare.client.controller.delegate.ISVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.SVNCacheManager;
import com.interpress_project.modernshare.client.controller.model.SVNFile;
import com.interpress_project.modernshare.client.controller.model.SVNFolder;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteSVNManager
extends ISVNManager {
    private static RemoteSVNManager instance;
    private SVNCacheManager cachemgr = new SVNCacheManager();

    private RemoteSVNManager() {
    }

    public static RemoteSVNManager getInstance() {
        if (instance == null) {
            instance = new RemoteSVNManager();
        }
        return instance;
    }

    public ArrayList<ISVNFileItem> getSVNFileItems(String url) throws InternalFailException {
        ArrayList<ISVNFileItem> list = new ArrayList<ISVNFileItem>();
        SVNUrl svnurl = this.createSVNUrl(url);
        ISVNDirEntry[] entry = null;
        try {
            entry = this.svnClient.getList(svnurl, SVNRevision.HEAD, false);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(url + "\u306b\u5bfe\u3059\u308b\u30ea\u30b9\u30c8\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getMessage() + ")");
        }
        for (int i = 0; i < entry.length; ++i) {
            ISVNDirEntry e = entry[i];
            if (e.getNodeKind() == SVNNodeKind.DIR) {
                list.add(new SVNFolder(e.getPath(), e.getSize(), e.getLastCommitAuthor(), e.getLastChangedDate(), e.getLastChangedRevision().getNumber(), e.getLastChangedRevision().getNumber(), url + "/" + e.getPath(), ""));
                continue;
            }
            list.add(new SVNFile(e.getPath(), e.getSize(), e.getLastCommitAuthor(), e.getLastChangedDate(), e.getLastChangedRevision().getNumber(), e.getLastChangedRevision().getNumber(), url + "/" + e.getPath(), ""));
        }
        return list;
    }

    public ArrayList<ISVNFileItem> getRevisionInfo(String url) throws InternalFailException {
        return this._getRevisionInfo(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ISVNFileItem> _getRevisionInfo(String url) throws InternalFailException {
        ArrayList result;
        SVNUrl svnurl = this.createSVNUrl(url);
        ISVNInfo info = null;
        String origurl = null;
        try {
            info = this.svnClient.getInfo(svnurl, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(url + "\u306e\u60c5\u5831\u53d6\u5f97(getInfo())\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u901a\u4fe1\u30a8\u30e9\u30fc\u304b\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u3066\u3044\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\n" + "\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3092\u3057\u3066\u30ea\u30b9\u30c8\u60c5\u5831\u3092\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002", ex);
        }
        origurl = info.getUrlString();
        ISVNFileItem item = null;
        do {
            item = this.createSVNFileItem(info);
            long rv = item.getRevision();
            long lcrv = item.getLastChangedRevision();
            if (!origurl.equals(item.getURL())) {
                --rv;
            } else if (rv == lcrv) {
                if (this.cachemgr.isCached(item)) {
                    sb.getLogger().debug((Object)("Cache hit: " + item.getURL()));
                    return this.cachemgr.getSVNFileItems(item.getURL());
                }
                this.cachemgr.addSVNFileItem(item);
                --rv;
            } else {
                rv = lcrv;
            }
            try {
                this.removeNotifyListener();
                SVNRevision.Number r = new SVNRevision.Number(rv);
                info = this.svnClient.getInfo(svnurl, (SVNRevision)r, SVNRevision.HEAD);
            }
            catch (SVNClientException e) {
                break;
            }
            finally {
                this.addNotifyListener();
            }
        } while (info != null);
        return (result = this.cachemgr.getSVNFileItems(origurl)) != null ? result : new ArrayList();
    }

    private ISVNFileItem createSVNFileItem(ISVNInfo info) {
        ISVNFileItem item = null;
        String lpath = info.getUrl().getLastPathSegment();
        String author = info.getLastCommitAuthor();
        Date lcdate = info.getLastChangedDate();
        long rv = info.getRevision().getNumber();
        long lcrv = info.getLastChangedRevision().getNumber();
        String u = info.getUrlString();
        String uuid = info.getUuid();
        item = SVNNodeKind.DIR == info.getNodeKind() ? new SVNFolder(lpath, 0L, author, lcdate, rv, lcrv, u, uuid) : new SVNFile(lpath, 0L, author, lcdate, rv, lcrv, u, uuid);
        return item;
    }

    public void deleteRemoteItem(ISVNFileItem[] items) throws InternalFailException {
        ArrayList<SVNUrl> list = new ArrayList<SVNUrl>();
        try {
            for (int i = 0; i < items.length; ++i) {
                list.add(new SVNUrl(items[i].getURL()));
            }
        }
        catch (MalformedURLException ex) {
            throw new InternalFailException(accounturl + "\u306b\u5bfe\u3059\u308b\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        SVNUrl[] us = list.toArray(new SVNUrl[list.size()]);
        try {
            this.svnClient.remove(us, new Date().toString());
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30ea\u30e2\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + ex.getMessage());
        }
    }

    public void exportItem(ISVNFileItem item, File file) throws InternalFailException {
        String url = item.getURL();
        SVNUrl svnurl = this.createSVNUrl(url);
        long rev = item.getRevision();
        SVNRevision.Number revision = new SVNRevision.Number(rev);
        try {
            this.svnClient.doExport(svnurl, file, (SVNRevision)revision, true);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30ea\u30e2\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb" + url + "\u306e\u30a8\u30ad\u30b9\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + ex.getMessage());
        }
    }
}

