/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate;

import com.interpress_project.modernshare.client.controller.delegate.ISVNManager;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.SVNFolderUtil;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.DeleteFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoNeedSyncException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.RenameFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.SVNFile;
import com.interpress_project.modernshare.client.controller.model.SVNFolder;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class LocalSVNManager
extends ISVNManager {
    private static LocalSVNManager instance;
    private final SVNFolderUtil futil = SVNFolderUtil.getInstance();

    private LocalSVNManager() {
    }

    public static LocalSVNManager getInstance() {
        if (instance == null) {
            instance = new LocalSVNManager();
        }
        return instance;
    }

    public void initialCheckoutFolder(File rootpath, String tagName) throws InternalFailException {
        SVNUrl u = this.createSVNUrl(accounturl + "/" + tagName);
        try {
            this.svnClient.mkdir(u, "Initial Import" + new Date().toString());
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(rootpath + "\u306b\u5bfe\u3059\u308b\u521d\u671fImport\u51e6\u7406\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        try {
            this.svnClient.checkout(u, rootpath, SVNRevision.HEAD, false);
            this.addIgnoredFilter(rootpath);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(rootpath + "\u306b\u5bfe\u3059\u308b\u521d\u671fcheckout\u51e6\u7406\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
    }

    public File[] initialRegisterFiles(File rootpath) throws InternalFailException {
        int i;
        ISVNStatus[] status = null;
        ArrayList<File> list = this.futil.getDirListInTarget(rootpath);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            File file = list.get(i2);
            try {
                this.svnClient.addDirectory(file, false);
                this.addIgnoredFilter(file);
                continue;
            }
            catch (SVNClientException ex) {
                throw new InternalFailException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea" + rootpath.getAbsolutePath() + "\u306e\u8ffd\u52a0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(addDirectory)", ex);
            }
        }
        try {
            status = this.checkDirectoryStatus(rootpath, true);
        }
        catch (NoNeedSyncException ex) {
            // empty catch block
        }
        for (i = 0; i < status.length; ++i) {
            ISVNStatus st = status[i];
            if (SVNStatusKind.UNVERSIONED != st.getTextStatus() || st.getFile().isDirectory()) continue;
            this.registerFile(st.getFile());
        }
        list = new ArrayList();
        for (i = 0; i < status.length; ++i) {
            if (status[i].getTextStatus() == SVNStatusKind.DELETED) continue;
            list.add(status[i].getFile());
        }
        return list.toArray(new File[list.size()]);
    }

    private void registerFolder(File dir) throws InternalFailException {
        if (!dir.isDirectory()) {
            return;
        }
        try {
            this.futil.deleteSVNFolders(dir);
        }
        catch (DeleteFailException ex) {
            throw new InternalFailException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea" + dir.getAbsolutePath() + "\u304b\u3089svn\u60c5\u5831\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        ArrayList<File> list = this.futil.getDirListInTarget(dir);
        try {
            this.svnClient.addDirectory(dir, false);
            this.addIgnoredFilter(dir);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea" + dir.getAbsolutePath() + "\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(addDirectory)", ex);
        }
        for (int i = 0; i < list.size(); ++i) {
            File file = list.get(i);
            try {
                this.svnClient.addDirectory(file, false);
                this.addIgnoredFilter(file);
                continue;
            }
            catch (SVNClientException ex) {
                throw new InternalFailException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea" + dir.getAbsolutePath() + "\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(addDirectory)", ex);
            }
        }
    }

    private void registerFile(File file) throws InternalFailException {
        if (file.isFile()) {
            try {
                this.svnClient.addFile(file);
            }
            catch (SVNClientException ex) {
                throw new InternalFailException("\u30d5\u30a1\u30a4\u30eb" + file.getAbsolutePath() + "\u306e\u8ffd\u52a0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(addFile)", ex);
            }
        }
    }

    private void unregisterFile(File file) throws InternalFailException, DeleteFailException {
        if (file.isDirectory() && this.svnClient.isAdminDirectory(file.getAbsolutePath())) {
            throw new DeleteFailException(file.getAbsolutePath() + "\u306f\u7ba1\u7406\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u3059\u3002\u524a\u9664\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        try {
            this.svnClient.remove(new File[]{file}, true);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(file.getAbsolutePath() + "\u306e\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(remove)", ex);
        }
    }

    public void checkoutFiles(File rootfile, String svnurl) throws InternalFailException {
        SVNUrl u = this.createSVNUrl(svnurl);
        try {
            this.svnClient.checkout(u, rootfile, SVNRevision.HEAD, true);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(rootfile.getAbsolutePath() + "\u306b\u5bfe\u3059\u308b\u30c1\u30a7\u30c3\u30af\u30a2\u30a6\u30c8\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + svnurl + ")", ex);
        }
        this.addIgnoredFilterToDirectory(rootfile);
    }

    public void addIgnoredFilterToDirectory(File rootpath) throws InternalFailException {
        ArrayList<File> list = this.futil.getDirListInTarget(rootpath);
        this.addIgnoredFilter(rootpath);
        for (int i = 0; i < list.size(); ++i) {
            this.addIgnoredFilter(list.get(i));
        }
    }

    public ArrayList<ISVNFileItem> getRevisionInfo(String fileName) throws InternalFailException {
        RemoteSVNManager rsvnmgr = RemoteSVNManager.getInstance();
        ISVNInfo info = null;
        try {
            info = this.svnClient.getInfo(new File(fileName));
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(fileName + "\u306b\u5bfe\u3059\u308b\u60c5\u5831\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(getInfo)", ex);
        }
        return rsvnmgr.getRevisionInfo(info.getUrlString());
    }

    public ISVNFileItem[] getSVNItems(String path) throws InternalFailException {
        ArrayList<SVNFolder> arrItems = new ArrayList<SVNFolder>();
        ISVNInfo entry = null;
        File file = new File(path);
        String abspath = file.getAbsolutePath();
        if (!file.exists()) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + abspath + "\u306f\u3001\u30ed\u30fc\u30ab\u30ebPC\u4e0a\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        try {
            entry = this.svnClient.getInfoFromWorkingCopy(file);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + abspath + "\u306e\u60c5\u5831\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(getInfoFromWorkingCopy)", ex);
        }
        if (entry instanceof SVNInfoUnversioned) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + abspath + "\u306f\u6b21\u56de\u540c\u671f\u5f85\u3061\u72b6\u614b\u304b\u540c\u671f\u5bfe\u8c61\u5916\u30d5\u30a1\u30a4\u30eb\u3067\u3059\u3002");
        }
        if (entry.getNodeKind() == SVNNodeKind.DIR && file.isFile()) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + abspath + "\u306f\u4e0d\u6574\u5408\u30ea\u30bd\u30fc\u30b9\u3067\u3059\u3002\u6b21\u56de\u306e\u540c\u671f\u51e6\u7406\u3067\u4fee\u6b63\u3055\u308c\u307e\u3059\u3002");
        }
        if (entry.getNodeKind() == SVNNodeKind.FILE && file.isDirectory()) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + abspath + "\u306f\u4e0d\u6574\u5408\u30ea\u30bd\u30fc\u30b9\u3067\u3059\u3002\u6b21\u56de\u306e\u540c\u671f\u51e6\u7406\u3067\u4fee\u6b63\u3055\u308c\u307e\u3059\u3002");
        }
        ISVNFileItem item = null;
        try {
            String name = entry.getFile().getName();
            long fsize = entry.getFile().length();
            String author = entry.getLastCommitAuthor();
            Date lcdate = entry.getLastChangedDate();
            long revision = entry.getRevision().getNumber();
            long lcrevision = entry.getLastChangedRevision().getNumber();
            String url = entry.getUrlString();
            String uuid = entry.getUuid();
            item = file.isDirectory() ? new SVNFolder(name, fsize, author, lcdate, revision, lcrevision, url, uuid) : new SVNFile(name, fsize, author, lcdate, revision, lcrevision, url, uuid);
            arrItems.add((SVNFolder)item);
        }
        catch (Exception ex) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + abspath + "\u306e\u60c5\u5831\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        return arrItems.toArray(new ISVNFileItem[arrItems.size()]);
    }

    public void cleanupFiles(File path) throws InternalFailException {
        sb.getLogger().debug((Object)"Enter cleanupFiles()");
        try {
            this.svnClient.cleanup(path);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + path.getAbsolutePath() + "\u306b\u5bfe\u3059\u308bCleanup\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
    }

    private ISVNStatus[] getStatus(File path, boolean bCheckRemote) throws InternalFailException {
        sb.getLogger().debug((Object)"Enter getStatus()");
        ISVNStatus[] status = null;
        try {
            status = this.svnClient.getStatus(path, true, false, bCheckRemote);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + path.getAbsolutePath() + "\u306e\u5909\u66f4\u72b6\u614b\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(getStatus)", ex);
        }
        return status;
    }

    private ISVNStatus[] checkDirectoryStatus(File path, boolean bCheckRemote) throws InternalFailException, NoNeedSyncException {
        sb.getLogger().debug((Object)"Enter checkDirectoryStatus()");
        ArrayList<ISVNStatus> list = new ArrayList<ISVNStatus>();
        ISVNStatus[] status = this.getStatus(path, bCheckRemote);
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getFile().getAbsolutePath().equalsIgnoreCase(path.getAbsolutePath()) || status[i].getTextStatus() == SVNStatusKind.NONE) continue;
            list.add(status[i]);
        }
        status = list.toArray(new ISVNStatus[list.size()]);
        if (status.length == 0) {
            throw new NoNeedSyncException();
        }
        boolean bNoNeedUpdate = true;
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getNodeKind() == SVNNodeKind.DIR && status[i].getTextStatus() == SVNStatusKind.NORMAL && status[i].getRepositoryTextStatus() == SVNStatusKind.NONE) continue;
            bNoNeedUpdate = false;
            break;
        }
        if (bNoNeedUpdate) {
            throw new NoNeedSyncException();
        }
        return status;
    }

    public void syncLocalFilesWithRemote(File path) throws InternalFailException {
        ISVNStatus st;
        int i;
        ISVNStatus[] status = null;
        try {
            status = this.checkDirectoryStatus(path, true);
        }
        catch (InternalFailException ex) {
            String msg = path + "\u306e\u5909\u66f4\u72b6\u614b\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30ed\u30fc\u30ab\u30eb\u306b\u7f6e\u304b\u308c\u305f\u60c5\u5831\u3092\u7528\u3044\u3066\u518d\u8a66\u884c\u3057\u307e\u3059\u3002(syncLocalFilesWithRemote)";
            logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
            try {
                status = this.checkDirectoryStatus(path, false);
            }
            catch (NoNeedSyncException e) {
                return;
            }
        }
        catch (NoNeedSyncException e) {
            return;
        }
        logEventSource.fireEvent(new LogEvent(this, path + "\u306b\u3042\u308b\u4e0d\u6574\u5408\u72b6\u614b\u306e\u30ea\u30bd\u30fc\u30b9\u3092\u691c\u51fa\u3057\u3066\u3044\u307e\u3059...", LogEventType.INFO));
        for (i = 0; i < status.length; ++i) {
            st = status[i];
            if (SVNStatusKind.OBSTRUCTED != st.getTextStatus()) continue;
            File localfile = st.getFile();
            try {
                logEventSource.fireEvent(new LogEvent(this, localfile.getAbsolutePath() + "\u306f\u4e0d\u6574\u5408\u72b6\u614b\u306e\u30ea\u30bd\u30fc\u30b9\u3067\u3059\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u6e08\u307f\u306e\u30ea\u30bd\u30fc\u30b9\u3067\u4fee\u6b63\u3092\u884c\u3044\u307e\u3059\u3002", LogEventType.INFO));
                this.futil.renameBkupFile(localfile);
                continue;
            }
            catch (RenameFailException ex) {
                logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
            }
        }
        try {
            status = this.checkDirectoryStatus(path, true);
        }
        catch (NoNeedSyncException ex) {
            return;
        }
        for (i = 0; i < status.length; ++i) {
            st = status[i];
            if (SVNStatusKind.CONFLICTED == st.getTextStatus()) {
                logEventSource.fireEvent(new LogEvent(this, st.getFile().getAbsolutePath() + "\u306f\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u5074\u3068\u30b3\u30f3\u30d5\u30ea\u30af\u30c8\u72b6\u614b\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3067\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u3092\u66f4\u65b0\u3057\u307e\u3059\u3002", LogEventType.INFO));
                try {
                    this.futil.renameBkupFile(st.getFile());
                }
                catch (RenameFailException ex) {
                    logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
                }
                continue;
            }
            if (SVNStatusKind.MISSING == st.getTextStatus()) {
                logEventSource.fireEvent(new LogEvent(this, st.getFile().getAbsolutePath() + "\u306f\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3067\u5fa9\u65e7\u3057\u307e\u3059\u3002", LogEventType.INFO));
                continue;
            }
            if (SVNStatusKind.UNVERSIONED != st.getTextStatus() && SVNStatusKind.MODIFIED != st.getTextStatus()) continue;
            logEventSource.fireEvent(new LogEvent(this, st.getFile().getAbsolutePath() + "\u306f\u30ed\u30fc\u30ab\u30eb\u306b\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3068\u540c\u671f\u3059\u308b\u305f\u3081\u306b\u5f85\u907f\u3057\u307e\u3059\u3002", LogEventType.INFO));
            try {
                this.futil.renameBkupFile(st.getFile());
                continue;
            }
            catch (RenameFailException ex) {
                logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
            }
        }
        this.cleanupFiles(path);
        this.remoteUpdate(path);
    }

    private void remoteUpdate(File localfile) throws InternalFailException {
        try {
            this.svnClient.update(localfile, SVNRevision.HEAD, true);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30ed\u30fc\u30ab\u30eb\u30ea\u30bd\u30fc\u30b9" + localfile.getAbsolutePath() + "\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(update)", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] prepareSyncRemoteFiles(File path) throws InternalFailException {
        boolean bRepeat;
        ISVNStatus[] status = null;
        sb.getLogger().debug((Object)"Enter prepareSyncRemoteFiles().");
        try {
            this.removeNotifyListener();
            status = this.checkDirectoryStatus(path, true);
        }
        catch (InternalFailException ex) {
            String msg = path + "\u306e\u5909\u66f4\u72b6\u614b\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30ed\u30fc\u30ab\u30eb\u306b\u7f6e\u304b\u308c\u305f\u60c5\u5831\u3092\u7528\u3044\u3066\u518d\u8a66\u884c\u3057\u307e\u3059\u3002(prepareSyncRemoteFiles)";
            logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
            try {
                status = this.checkDirectoryStatus(path, false);
            }
            catch (NoNeedSyncException e) {
                File[] fileArray = new File[]{};
                return fileArray;
            }
        }
        catch (NoNeedSyncException e) {
            File[] msg = new File[]{};
            return msg;
        }
        finally {
            this.addNotifyListener();
        }
        logEventSource.fireEvent(new LogEvent(this, path + "\u306b\u3042\u308b\u4e0d\u6574\u5408\u72b6\u614b\u306e\u30ea\u30bd\u30fc\u30b9\u3092\u691c\u51fa\u3057\u3066\u3044\u307e\u3059...", LogEventType.INFO));
        for (int i = 0; i < status.length; ++i) {
            ISVNStatus st = status[i];
            if (SVNStatusKind.OBSTRUCTED != st.getTextStatus()) continue;
            File localfile = st.getFile();
            try {
                String msg = localfile.getAbsolutePath() + "\u306f\u4e0d\u6574\u5408\u72b6\u614b\u306e\u30ea\u30bd\u30fc\u30b9\u3067\u3059\u3002\u30ed\u30fc\u30ab\u30eb\u306b\u7f6e\u304b\u308c\u305f\u30ea\u30bd\u30fc\u30b9\u3067\u4fee\u6b63\u3092\u884c\u3044\u307e\u3059\u3002";
                logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
                if (localfile.isDirectory()) {
                    this.RecoverFolderToFile(localfile);
                    continue;
                }
                this.RecoverFileToFolder(localfile);
                continue;
            }
            catch (RenameFailException ex) {
                throw new InternalFailException(ex);
            }
        }
        do {
            bRepeat = false;
            try {
                status = this.checkDirectoryStatus(path, true);
            }
            catch (NoNeedSyncException ex) {
                // empty catch block
            }
            for (int i = 0; i < status.length; ++i) {
                ISVNStatus st = status[i];
                if (SVNStatusKind.MODIFIED == st.getRepositoryTextStatus()) {
                    logEventSource.fireEvent(new LogEvent(this, st.getFile().getAbsolutePath() + "\u306f\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u5074\u3067\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u3067\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3092\u66f4\u65b0\u3057\u307e\u3059\u3002", LogEventType.INFO));
                    try {
                        this.RecoverModifiedRemoteFileWithLocal(st);
                    }
                    catch (Exception ex) {
                        logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
                    }
                    continue;
                }
                if (SVNStatusKind.CONFLICTED == st.getTextStatus()) {
                    logEventSource.fireEvent(new LogEvent(this, st.getFile().getAbsolutePath() + "\u306f\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u5074\u3068\u30b3\u30f3\u30d5\u30ea\u30af\u30c8\u72b6\u614b\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002\u30ed\u30fc\u30ab\u30eb\u30d5\u30a1\u30a4\u30eb\u3067\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3092\u66f4\u65b0\u3057\u307e\u3059\u3002", LogEventType.INFO));
                    try {
                        this.RecoverModifiedRemoteFileWithLocal(st);
                    }
                    catch (Exception ex) {
                        logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
                    }
                    continue;
                }
                if (SVNStatusKind.MISSING == st.getTextStatus()) {
                    logEventSource.fireEvent(new LogEvent(this, st.getFile().getAbsolutePath() + "\u306f\u524a\u9664\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3082\u524a\u9664\u3057\u307e\u3059\u3002", LogEventType.INFO));
                    try {
                        this.unregisterFile(st.getFile());
                    }
                    catch (DeleteFailException ex) {
                        logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
                    }
                    catch (InternalFailException ex) {
                        sb.getLogger().error((Object)ex.getMessage());
                    }
                    continue;
                }
                if (SVNStatusKind.UNVERSIONED != st.getTextStatus()) continue;
                logEventSource.fireEvent(new LogEvent(this, st.getFile().getAbsolutePath() + "\u306f\u30ed\u30fc\u30ab\u30eb\u306b\u8ffd\u52a0\u3055\u308c\u307e\u3057\u305f\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u65b0\u898f\u767b\u9332\u3092\u3057\u307e\u3059\u3002", LogEventType.INFO));
                File file = st.getFile();
                if (file.isDirectory()) {
                    this.registerFolder(file);
                    bRepeat = true;
                    continue;
                }
                this.registerFile(file);
            }
        } while (bRepeat);
        ArrayList<File> list = new ArrayList<File>();
        try {
            status = this.checkDirectoryStatus(path, false);
        }
        catch (NoNeedSyncException e) {
            return new File[0];
        }
        for (int i = 0; i < status.length; ++i) {
            if (status[i].getTextStatus() == SVNStatusKind.DELETED) continue;
            list.add(status[i].getFile());
        }
        return list.toArray(new File[list.size()]);
    }

    private void RecoverModifiedRemoteFileWithLocal(ISVNStatus st) throws RenameFailException, DeleteFailException, InternalFailException {
        File destfile;
        String src = st.getFile().getAbsolutePath();
        String dest = src + ".orig." + System.currentTimeMillis();
        File localfile = st.getFile();
        if (!localfile.renameTo(destfile = new File(dest))) {
            throw new RenameFailException(src + "\u306b\u5bfe\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(RecoverModifiedRemoteFileWithLocal)");
        }
        try {
            this.svnClient.update(localfile, SVNRevision.HEAD, true);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(ex);
        }
        try {
            FileUtils.forceDelete((File)localfile);
        }
        catch (IOException ex) {
            throw new DeleteFailException(src + "\u306b\u5bfe\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(RecoverModifiedRemoteFileWithLocal)");
        }
        sb.gc();
        if (!destfile.renameTo(localfile)) {
            throw new RenameFailException(dest + "\u306b\u5bfe\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(RecoverModifiedRemoteFileWithLocal)");
        }
        try {
            FileUtils.touch((File)localfile);
        }
        catch (IOException ex) {
            throw new RenameFailException(src + "\u306b\u5bfe\u3059\u308btouch()\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(RecoverModifiedRemoteFileWithLocal)");
        }
    }

    private void RecoverFolderToFile(File localfile) throws RenameFailException, InternalFailException {
        String src = null;
        String dist = null;
        src = localfile.getAbsolutePath();
        dist = src + ".orig." + System.currentTimeMillis();
        File bkupfile = new File(dist);
        if (!localfile.renameTo(bkupfile)) {
            throw new RenameFailException(src + "\u306b\u5bfe\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(RecoverFolderToFile)");
        }
        try {
            this.svnClient.remove(new File[]{localfile}, true);
            this.svnClient.addFile(bkupfile);
            this.svnClient.commit(new File[]{localfile, bkupfile}, "Recovery step.1", true);
            this.svnClient.move(bkupfile, localfile, true);
            this.svnClient.commit(new File[]{localfile, bkupfile}, "Recovery step.2", true);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(ex);
        }
    }

    private void RecoverFileToFolder(File localfile) throws RenameFailException, InternalFailException {
        String src = null;
        String dist = null;
        src = localfile.getAbsolutePath();
        dist = src + ".orig." + System.currentTimeMillis();
        File bkupfile = new File(dist);
        if (!localfile.renameTo(bkupfile)) {
            throw new RenameFailException("\u4e0d\u6574\u5408\u72b6\u614b\u30ea\u30bd\u30fc\u30b9\u5fa9\u65e7\u4e2d\u306e\u30a8\u30e9\u30fc: " + src + "\u306b\u5bfe\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u540d\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(RecoverFileToFolder)");
        }
        try {
            this.svnClient.update(localfile, SVNRevision.HEAD, false);
            this.svnClient.remove(new File[]{localfile}, true);
            this.svnClient.addFile(bkupfile);
            this.svnClient.commit(new File[]{localfile, bkupfile}, "Recovery step.1", true);
            this.svnClient.move(bkupfile, localfile, true);
            this.svnClient.commit(new File[]{localfile, bkupfile}, "Recovery step.2", true);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(ex);
        }
    }
}

