/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.delegate;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.AccountNotFoundException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.TagExistException;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.GUIEventSource;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class ISVNManager
implements ISVNNotifyListener {
    protected static SystemBase sb = SystemBase.getInstance();
    protected static PropertyManager propmgr = PropertyManager.getInstance();
    protected static LogEventSource logEventSource = LogEventSource.getInstance();
    protected static GUIEventSource guiEventSource = GUIEventSource.getInstance();
    protected static SVNUrl svnAccounturl = null;
    protected static String accounturl = null;
    protected static SVNUrl svnHosturl = null;
    protected static String hosturl = null;
    protected ISVNClientAdapter svnClient = null;
    protected boolean bConnected = false;
    private String[] ignoredfilter = null;
    private String account = null;

    public ISVNManager() {
        try {
            JhlClientAdapterFactory.setup();
        }
        catch (SVNClientException e) {
            // empty catch block
        }
        String bestClientType = null;
        try {
            bestClientType = SVNClientAdapterFactory.getPreferredSVNClientType();
        }
        catch (SVNClientException ex) {
            sb.getLogger().fatal((Object)("JhlClientAdapter: \u30a2\u30c0\u30d7\u30bf\u306e\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3059\u3002(" + ex.getMessage() + ")"), (Throwable)ex);
            System.exit(-1);
        }
        this.svnClient = SVNClientAdapterFactory.createSVNClient((String)bestClientType);
        this.addNotifyListener();
        this.ignoredfilter = propmgr.getIgnoreFilterList();
    }

    protected void addNotifyListener() {
        this.svnClient.addNotifyListener((ISVNNotifyListener)this);
    }

    protected void removeNotifyListener() {
        this.svnClient.removeNotifyListener((ISVNNotifyListener)this);
    }

    public void connect() throws ConnectionFailException {
        String account = propmgr.getUsername();
        String password = propmgr.getPassword();
        this.connect(account, password);
    }

    public void connect(String account, String password) throws ConnectionFailException {
        sb.getLogger().debug((Object)("\u63a5\u7d9a\u3092\u958b\u59cb\u3057\u307e\u3059\u3002(" + account + ")"));
        this.account = account;
        this.svnClient.setUsername(account);
        this.svnClient.setPassword(password);
        if (this.bConnected) {
            sb.getLogger().debug((Object)("\u63a5\u7d9a\u6e08\u307f\u3067\u3059\u3002(" + account + ")"));
            return;
        }
        hosturl = propmgr.getTargetSVNURL();
        accounturl = propmgr.getTargetSVNURL(account);
        try {
            svnAccounturl = new SVNUrl(accounturl);
            svnHosturl = new SVNUrl(hosturl);
        }
        catch (MalformedURLException ex) {
            this.bConnected = false;
            throw new ConnectionFailException(accounturl + "\u306b\u5bfe\u3059\u308b\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getMessage() + ")", ex);
        }
        try {
            sb.getLogger().debug((Object)(propmgr.getAdminHost() + "\u3078\u306eping\u3092\u884c\u3044\u307e\u3059\u3002"));
            this.svnClient.getInfo(svnHosturl);
        }
        catch (SVNClientException ex) {
            this.bConnected = false;
            throw new ConnectionFailException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf" + propmgr.getAdminHost() + "\u3078\u63a5\u7d9a\u4e2d\u306b\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30db\u30b9\u30c8\u60c5\u5831\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002", ex);
        }
        sb.getLogger().debug((Object)("\u63a5\u7d9a\u304c\u6210\u529f\u3057\u307e\u3057\u305f\u3002(" + account + ")"));
        this.bConnected = true;
    }

    public void addIgnoredFilter(File file) throws InternalFailException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.ignoredfilter.length; ++i) {
            list.add(this.ignoredfilter[i]);
        }
        try {
            this.svnClient.setIgnoredPatterns(file, list);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException(file.getAbsolutePath() + "\u3078\u306e\u9664\u5916\u30d1\u30bf\u30fc\u30f3\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
    }

    public void existAccount() throws AccountNotFoundException {
        try {
            this.svnClient.getInfo(svnAccounturl);
        }
        catch (SVNClientException ex) {
            throw new AccountNotFoundException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u3001\u30a2\u30ab\u30a6\u30f3\u30c8" + this.account + "\u306f\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", ex);
        }
    }

    private ISVNDirEntry[] _getTagNames() throws InternalFailException {
        ISVNDirEntry[] entries = null;
        try {
            entries = this.svnClient.getList(svnAccounturl, SVNRevision.HEAD, false);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30a2\u30ab\u30a6\u30f3\u30c8" + this.account + "\u306b\u5bfe\u3059\u308b\u30bf\u30b0\u540d\u30ea\u30b9\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
        }
        return entries;
    }

    public void existTagName(String tagName) throws InternalFailException, TagExistException {
        ISVNDirEntry[] tagnames = this._getTagNames();
        for (int i = 0; i < tagnames.length; ++i) {
            String tgname = tagnames[i].getPath();
            if (!tgname.equalsIgnoreCase(tagName)) continue;
            throw new TagExistException("\u30bf\u30b0\u540d" + tagName + "\u306f\u3001\u65e2\u306b\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
    }

    public ArrayList<SVNRoot> getTagNames() throws InternalFailException {
        ArrayList<SVNRoot> list = new ArrayList<SVNRoot>();
        ISVNDirEntry[] tagnames = this._getTagNames();
        for (int i = 0; i < tagnames.length; ++i) {
            long revision;
            ISVNDirEntry entry = tagnames[i];
            String name = entry.getPath();
            long fsize = entry.getSize();
            String author = entry.getLastCommitAuthor();
            Date lcdate = entry.getLastChangedDate();
            long lcrevision = revision = entry.getLastChangedRevision().getNumber();
            SVNNodeKind kind = entry.getNodeKind();
            if (kind != SVNNodeKind.DIR) continue;
            list.add(new SVNRoot(name, fsize, author, lcdate, revision, lcrevision, accounturl + "/" + name, ""));
        }
        return list;
    }

    protected SVNUrl createSVNUrl(String url) throws InternalFailException {
        SVNUrl u = null;
        try {
            u = new SVNUrl(url);
        }
        catch (MalformedURLException ex) {
            throw new InternalFailException(url + "\u306b\u5bfe\u3059\u308b\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + ex.getMessage() + ")", ex);
        }
        return u;
    }

    public void deleteRemoteFolder(String tagName) throws InternalFailException {
        SVNUrl u = this.createSVNUrl(accounturl + "/" + tagName);
        String msg = "Unregister deletion at" + new Date().toString();
        try {
            this.svnClient.remove(new SVNUrl[]{u}, msg);
        }
        catch (SVNClientException ex) {
            throw new InternalFailException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u3042\u308b\u30d5\u30a9\u30eb\u30c0" + tagName + "\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002(" + u.toString() + ")", ex);
        }
    }

    public void commitDirectory(File rootpath, File[] pathes) throws InternalFailException {
        try {
            String msg = "Committed at " + new Date().toString();
            this.svnClient.commit(new File[]{rootpath}, msg, true);
            logEventSource.fireEvent(new LogEvent(this, "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3078\u306e\u540c\u671f\u30b3\u30df\u30c3\u30c8\u304c\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002", LogEventType.INFO));
        }
        catch (SVNClientException ex) {
            for (int i = 0; i < pathes.length; ++i) {
                if (pathes[i].exists()) continue;
                try {
                    FileUtils.touch((File)pathes[i]);
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw new InternalFailException("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3078\u306e\u540c\u671f\u30b3\u30df\u30c3\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public void logCommandLine(String msg) {
        msg = msg.replace("\r", "");
        msg = msg.replace("\n", " ");
        sb.getLogger().debug((Object)("Enter logCommandLine : " + msg));
    }

    public void logCompleted(String msg) {
        logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
    }

    public void logError(String msg) {
        msg = msg.replace("\r", "");
        msg = msg.replace("\n", " ");
        logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.ERROR));
    }

    public void logMessage(String msg) {
        logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
    }

    public void logRevision(long arg0, String msg) {
        logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.INFO));
    }

    public void onNotify(File arg0, SVNNodeKind arg1) {
    }

    public void setCommand(int arg0) {
    }
}

