/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoPermissionException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.UnknownHostException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.util.ArrayList;
import java.util.Hashtable;

public class SyncListCommand
extends ISVNCommand {
    private final SystemBase sb = SystemBase.getInstance();
    private final ORBManager orbmgr = ORBManager.getInstance();
    private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();

    @Override
    public void execute() throws CommandException {
        int i;
        this.sb.getLogger().debug((Object)"Enter SyncListCommand().execute");
        try {
            this.orbmgr.updateSVNServerInfo();
        }
        catch (NoPermissionException ex) {
            throw new CommandException(ex);
        }
        catch (ConnectionFailException ex) {
            throw new CommandException(ex);
        }
        catch (UnknownHostException ex) {
            throw new CommandException(ex);
        }
        try {
            this.svnmgr.connect();
        }
        catch (ConnectionFailException ex) {
            throw new CommandException(ex);
        }
        ArrayList<SVNRoot> tagnames = null;
        try {
            tagnames = this.svnmgr.getTagNames();
        }
        catch (InternalFailException ex) {
            throw new CommandException(ex);
        }
        ArrayList<String> arrLocal = new ArrayList<String>();
        Hashtable<String, String> htRemote = new Hashtable<String, String>();
        LocalModelManager lmmgr = LocalModelManager.getInstance();
        LocalRoot[] roots = lmmgr.getRootLineItem().getRoots();
        for (i = 0; i < roots.length; ++i) {
            arrLocal.add(roots[i].getName());
        }
        for (i = 0; i < tagnames.size(); ++i) {
            ISVNFileItem item = tagnames.get(i);
            htRemote.put(item.getName(), item.getName());
        }
        for (i = 0; i < arrLocal.size(); ++i) {
            String locTagname = (String)arrLocal.get(i);
            String rmtTagname = (String)htRemote.get(locTagname);
            if (rmtTagname != null) continue;
            lmmgr.removeRootByTagname(locTagname);
        }
        this.sb.getLogger().debug((Object)"Leave SyncListCommand().execute");
    }
}

