/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Display;

public class SVNCommandManager {
    private final SystemBase sb = SystemBase.getInstance();
    private final LogEventSource logEventSource = LogEventSource.getInstance();
    private CommandWorkerThread thread = null;
    private BlockingQueue<ISVNCommand> queue = new LinkedBlockingQueue<ISVNCommand>();
    private static SVNCommandManager instance = null;

    private SVNCommandManager() {
    }

    public static SVNCommandManager getInstance() {
        if (instance == null) {
            instance = new SVNCommandManager();
        }
        return instance;
    }

    public void addCommand(ISVNCommand command) {
        try {
            this.queue.put(command);
            this.sb.getLogger().debug((Object)"Command registered in QUEUE.");
        }
        catch (InterruptedException ex) {
            this.sb.getLogger().error((Object)"InterruptedException registering a command.: ", (Throwable)ex);
        }
    }

    public void execCommand(ISVNCommand command) throws CommandException {
        this.sb.getLogger().debug((Object)("Enter sync execCommand(" + command.getClass().getName() + ")"));
        command.execute();
        this.sb.getLogger().debug((Object)("Leave sync execCommand(" + command.getClass().getName() + ")"));
    }

    public void start() {
        if (this.thread != null) {
            return;
        }
        this.thread = new CommandWorkerThread(this.queue);
        this.thread.setDaemon(true);
        this.thread.start();
        this.sb.getLogger().debug((Object)"CommandManager started.");
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.terminate();
            this.thread = null;
        }
        this.sb.getLogger().debug((Object)"CommandManager terminated.");
    }

    public void dispose() {
        this.stop();
        this.queue.clear();
        this.sb.getLogger().debug((Object)"CommandManager disposed.");
    }

    private class CommandWorkerThread
    extends Thread {
        private BlockingQueue<ISVNCommand> queue;
        private boolean bRunning;

        public CommandWorkerThread(BlockingQueue<ISVNCommand> queue) {
            this.queue = queue;
            this.bRunning = true;
        }

        @Override
        public void run() {
            SVNCommandManager.this.sb.getLogger().debug((Object)"CommandWorkerThread() started.");
            while (this.bRunning) {
                ISVNCommand command;
                try {
                    command = this.queue.poll(6L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (command == null) continue;
                SVNCommandManager.this.sb.getLogger().debug((Object)"Take task from queue.");
                Display disp = ViewManager.getInstance().getShell().getDisplay();
                disp.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            command.execute();
                        }
                        catch (CommandException ex) {
                            SVNCommandManager.this.logEventSource.fireEvent(new LogEvent(this, ex.getCause().getMessage(), LogEventType.ERROR, ex));
                        }
                    }
                });
            }
            SVNCommandManager.this.sb.getLogger().debug((Object)"CommandWorkerThread() terminated.");
        }

        public void terminate() {
            this.bRunning = false;
            this.interrupt();
        }
    }
}

