/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.File;

public class CheckoutCommand
extends ISVNCommand {
    private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
    private final LocalModelManager lmmgr = LocalModelManager.getInstance();
    private final SystemBase sb = SystemBase.getInstance();
    private File path;
    private SVNRoot root;
    private RootStatus status;
    private boolean bPc2host;

    public CheckoutCommand(String path, SVNRoot root, RootStatus status, boolean bPc2host) {
        this.path = new File(path);
        this.root = root;
        this.status = status;
        this.bPc2host = bPc2host;
    }

    @Override
    public void execute() throws CommandException {
        String svnurl = this.root.getURL();
        try {
            this.svnmgr.checkoutFiles(this.path, svnurl);
        }
        catch (InternalFailException ex) {
            throw new CommandException(ex);
        }
        this.lmmgr.addRoot(this.path.getAbsolutePath(), this.root.getName(), this.status, this.bPc2host);
        this.sb.getLogger().debug((Object)this.sb.gc());
    }
}

