/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.ViewEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class StartupSyncAction
extends ActionAdaptor {
    private final SystemBase sb = SystemBase.getInstance();
    private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
    private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
    private final ViewManager vmgr;

    public StartupSyncAction(ViewManager vmgr) {
        this.setText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u304b\u3089\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u3092\u540c\u671f(&S)");
        this.setToolTipText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30c7\u30fc\u30bf\u3067\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u3092\u540c\u671f\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("syncserver"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskManager taskmgr = TaskManager.getInstance();
        try {
            taskmgr.stop();
            this.cmdmgr.execCommand(this.factory.createUpdateClientXMLCommand());
            this.localViewEventSource.fireEvent(new LocalViewEvent((Object)this, ViewEventType.REFRESH));
            this.cmdmgr.execCommand(this.factory.createSyncListCommand());
            LocalModelManager lmmgr = LocalModelManager.getInstance();
            LocalRoot[] roots = lmmgr.getRootLineItem().getActiveRoots();
            if (roots.length == 0) {
                this.vmgr.getDialogManager().createInformationMessageDialog("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3068\u306e\u540c\u671f\u78ba\u8a8d", "\u81ea\u52d5\u66f4\u65b0\u30e2\u30fc\u30c9\u306e\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u306f\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            boolean bResult = this.vmgr.getDialogManager().createYesNoMessageDialog("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3068\u306e\u540c\u671f\u78ba\u8a8d", "\u5168\u3066\u306e\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u3092\u3001\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u3068\u540c\u671f\u3057\u307e\u3059\u304b? (\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u3055\u308c\u305f\u30c7\u30fc\u30bf\u3067\u30ed\u30fc\u30ab\u30ebPC\u306e\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\u304c\u66f4\u65b0\u3055\u308c\u307e\u3059\u3002)");
            if (!bResult) {
                return;
            }
            for (int i = 0; i < roots.length; ++i) {
                String msg;
                try {
                    msg = "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + roots[i].getAbsolutePath() + "\u3092\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30c7\u30fc\u30bf\u3067\u540c\u671f\u3057\u3066\u3044\u307e\u3059...";
                    this.guiEventSource.fireEvent(new GUIEvent((Object)this, msg, GUIEventType.START));
                    this.cmdmgr.execCommand(this.factory.createSyncLocalWithRemoteCommand(roots[i]));
                    continue;
                }
                finally {
                    msg = "\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0" + roots[i].getAbsolutePath() + "\u306e\u540c\u671f\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002";
                    this.guiEventSource.fireEvent(new GUIEvent((Object)this, msg, GUIEventType.FINISH));
                    roots[i].setDirty(false);
                }
            }
        }
        catch (CommandException ex) {
            String msg = ex.getCause().getMessage();
            this.logEventSource.fireEvent(new LogEvent((Object)this, msg, LogEventType.ERROR, ex));
            this.vmgr.getDialogManager().createErrorMessageDialog(msg);
        }
        finally {
            taskmgr.start();
        }
    }
}

