/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.GUIEvent;
import com.interpress_project.modernshare.client.events.GUIEventType;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

public final class RemoteDeleteAction
extends ActionAdaptor {
    private final ViewManager vmgr;
    private final RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
    private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
    private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
    private ISVNFileItem[] items = null;

    public RemoteDeleteAction(ViewManager vmgr, ISVNFileItem[] items) {
        this.setText("\u524a\u9664(&D)");
        this.setToolTipText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u304b\u3089\u30e6\u30fc\u30b6\u30fb\u30ea\u30bd\u30fc\u30b9\u3092\u524a\u9664\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("delete"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskManager taskmgr = TaskManager.getInstance();
        try {
            taskmgr.stop();
            boolean bResult = this.vmgr.getDialogManager().createYesNoMessageDialog("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306e\u30ea\u30bd\u30fc\u30b9\u524a\u9664\u78ba\u8a8d", "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u3055\u308c\u305f\u30ea\u30bd\u30fc\u30b9\u3092\u524a\u9664\u3057\u307e\u3059\u3002\u524a\u9664\u5f8c\u3001\u30db\u30c3\u30c8\u30b7\u30e7\u30c3\u30c8\u30fb\u30d5\u30a9\u30eb\u30c0\u3092DataCenter -> PC\u30e2\u30fc\u30c9\u3067\u66f4\u65b0\u3057\u3066\u304f\u3060\u3055\u3044\u3002 ");
            if (!bResult) {
                return;
            }
            this.guiEventSource.fireEvent(new GUIEvent((Object)this, "\u30ea\u30e2\u30fc\u30c8\u30fb\u30ea\u30bd\u30fc\u30b9\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059...", GUIEventType.START));
            try {
                this.svnmgr.connect();
            }
            catch (ConnectionFailException ex) {
                this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
                this.guiEventSource.fireEvent(new GUIEvent((Object)this, GUIEventType.FINISH));
                taskmgr.start();
                return;
            }
            try {
                this.svnmgr.deleteRemoteItem(this.items);
            }
            catch (InternalFailException ex) {
                this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
                this.guiEventSource.fireEvent(new GUIEvent((Object)this, GUIEventType.FINISH));
                taskmgr.start();
                return;
            }
            ISVNCommand command = this.factory.createRemoteRefreshCommand();
            this.cmdmgr.addCommand(command);
        }
        finally {
            this.guiEventSource.fireEvent(new GUIEvent((Object)this, GUIEventType.FINISH));
            taskmgr.start();
        }
    }
}

