/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;

public final class LocalExportAction
extends ActionAdaptor {
    private final ViewManager vmgr;
    private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
    private String fileName;

    public LocalExportAction(ViewManager vmgr, String fileName) {
        this.setText("\u30c7\u30fc\u30bf\u306e\u53d6\u308a\u51fa\u3057(&X)");
        this.setToolTipText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u3055\u308c\u305f\u30c7\u30fc\u30bf\u3092\u53d6\u308a\u51fa\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("export"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskManager taskmgr = TaskManager.getInstance();
        ArrayList<ISVNFileItem> revlist = new ArrayList();
        try {
            taskmgr.stop();
            this.logEventSource.fireEvent(new LogEvent((Object)this, LogEventType.CLEAR));
            MessageDialog dlg = new MessageDialog(this.vmgr.getShell(), "\u30ea\u30d3\u30b8\u30e7\u30f3\u306e\u53d6\u5f97", null, "\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u304b\u3089\u30ea\u30d3\u30b8\u30e7\u30f3\u30ea\u30b9\u30c8\u3092\u53d6\u5f97\u3057\u3066\u3044\u307e\u3059\u3002\u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044...", 2, new String[0], 0);
            dlg.setBlockOnOpen(false);
            try {
                dlg.open();
                try {
                    this.svnmgr.connect();
                }
                catch (ConnectionFailException ex) {
                    this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                    this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
                    dlg.close();
                    taskmgr.start();
                    return;
                }
                try {
                    revlist = this.svnmgr.getRevisionInfo(this.fileName);
                }
                catch (InternalFailException ex) {
                    this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                    this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
                    dlg.close();
                    taskmgr.start();
                    return;
                }
            }
            finally {
                dlg.close();
            }
            this.vmgr.getDialogManager().createLocalExportWizard(revlist);
        }
        finally {
            taskmgr.start();
        }
    }
}

