/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

public final class ImageFactory {
    private SystemBase sb = SystemBase.getInstance();
    private static ImageFactory instance = new ImageFactory();
    private Hashtable<String, ImageDescriptor> ht = new Hashtable();
    private Hashtable<String, Image> htImage = new Hashtable();

    protected ImageFactory() {
        this.loadingImages();
    }

    private void loadingImages() {
        ImageDescriptor imgdesc = null;
        try {
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/unconnected.gif"));
            this.ht.put("unconnected", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/connected.gif"));
            this.ht.put("connected", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/connected_ro.gif"));
            this.ht.put("connected_ro", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/exit.png"));
            this.ht.put("exit", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/co.png"));
            this.ht.put("chkout", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/help.gif"));
            this.ht.put("help", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/about.gif"));
            this.ht.put("about", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/folder.png"));
            this.ht.put("folder", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/file.gif"));
            this.ht.put("file", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/rfolder.gif"));
            this.ht.put("rfolder", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/rfile.gif"));
            this.ht.put("rfile", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/property.gif"));
            this.ht.put("property", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/register.png"));
            this.ht.put("register", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/security.png"));
            this.ht.put("security", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/delete.gif"));
            this.ht.put("delete", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/disable.png"));
            this.ht.put("disable", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/sync.png"));
            this.ht.put("sync", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/syncserver.png"));
            this.ht.put("syncserver", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/repository.gif"));
            this.ht.put("repository", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/refresh.png"));
            this.ht.put("refresh", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/localpc.png"));
            this.ht.put("localpc", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/remotepc.png"));
            this.ht.put("remotepc", imgdesc);
            imgdesc = ImageDescriptor.createFromURL((URL)new URL("file:images/export.png"));
            this.ht.put("export", imgdesc);
        }
        catch (MalformedURLException ex) {
            this.sb.getLogger().fatal((Object)"\u30a2\u30a4\u30b3\u30f3\u30d5\u30a1\u30a4\u30eb\u306e\u30ed\u30fc\u30c7\u30a3\u30f3\u30b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
    }

    public void dispose() {
        Enumeration<String> enumeration = this.ht.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            ImageDescriptor desc = this.ht.get(key);
            desc.createImage().dispose();
        }
    }

    public Image getImage(String name) {
        ImageDescriptor desc = this.getImageDescriptor(name);
        Image image = desc.createImage();
        return image;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        ImageDescriptor desc = this.ht.get(name);
        if (desc == null) {
            this.sb.getLogger().fatal((Object)(name + " not found in image repository."));
            System.exit(-1);
        }
        return desc;
    }

    public Image getAssociatedImageToFile(String fileName) {
        Image image = null;
        String ext = FilenameUtils.getExtension((String)fileName);
        if (ext == null) {
            image = ImageFactory.getInstance().getImage("file");
            return image;
        }
        image = this.htImage.get(ext);
        if (image != null) {
            return image;
        }
        Program program = Program.findProgram((String)ext);
        if (program == null) {
            image = ImageFactory.getInstance().getImage("file");
            return image;
        }
        ImageData data = program.getImageData();
        if (data == null) {
            image = ImageFactory.getInstance().getImage("file");
            return image;
        }
        image = new Image(null, data);
        this.htImage.put(ext, image);
        return image;
    }

    public static ImageFactory getInstance() {
        return instance;
    }
}

