/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.actions.ActionAdaptor;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

public final class ExportAction
extends ActionAdaptor {
    private final ViewManager vmgr;
    private final RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();
    private ISVNFileItem item = null;

    public ExportAction(ViewManager vmgr, ISVNFileItem item) {
        this.setText("\u30c7\u30fc\u30bf\u306e\u53d6\u308a\u51fa\u3057(&X)");
        this.setToolTipText("\u30c7\u30fc\u30bf\u30bb\u30f3\u30bf\u306b\u683c\u7d0d\u3055\u308c\u305f\u30c7\u30fc\u30bf\u3092\u53d6\u308a\u51fa\u3057\u307e\u3059\u3002");
        try {
            this.setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("export"));
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"\u30ea\u30bd\u30fc\u30b9\u8a2d\u5b9a\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ex);
            System.exit(-1);
        }
        this.vmgr = vmgr;
        this.item = item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TaskManager taskmgr = TaskManager.getInstance();
        try {
            taskmgr.stop();
            this.logEventSource.fireEvent(new LogEvent((Object)this, LogEventType.CLEAR));
            try {
                this.svnmgr.connect();
            }
            catch (ConnectionFailException ex) {
                this.logEventSource.fireEvent(new LogEvent((Object)this, ex.getMessage(), LogEventType.ERROR, ex));
                this.vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
                taskmgr.start();
                return;
            }
            this.vmgr.getDialogManager().createRemoteExportWizard(this.item);
        }
        finally {
            taskmgr.start();
        }
    }
}

